/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.organization;

import java.util.Map;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.identity.ContactData;
import org.bonitasoft.engine.identity.ContactDataUpdater;
import org.bonitasoft.engine.identity.UserUpdater;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.identity.PersonalContactDataItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.datastore.organization.ContactDataConverter;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class PersonalContactDataDatastore
extends CommonDatastore<PersonalContactDataItem, ContactData>
implements DatastoreHasGet<PersonalContactDataItem>,
DatastoreHasUpdate<PersonalContactDataItem>,
DatastoreHasAdd<PersonalContactDataItem> {
    public PersonalContactDataDatastore(APISession engineSession) {
        super(engineSession);
    }

    @Override
    public PersonalContactDataItem get(APIID id) {
        try {
            ContactData result = TenantAPIAccessor.getIdentityAPI((APISession)this.getEngineSession()).getUserContactData(id.toLong().longValue(), true);
            return this.createContactDataItemConverter(id).convert(result);
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public PersonalContactDataItem update(APIID id, Map<String, String> attributes) {
        try {
            ContactDataUpdater personalDataUpdater = new ContactDataUpdater();
            if (attributes.containsKey("email")) {
                personalDataUpdater.setEmail(attributes.get("email"));
            }
            if (attributes.containsKey("phone_number")) {
                personalDataUpdater.setPhoneNumber(attributes.get("phone_number"));
            }
            if (attributes.containsKey("mobile_number")) {
                personalDataUpdater.setMobileNumber(attributes.get("mobile_number"));
            }
            if (attributes.containsKey("fax_number")) {
                personalDataUpdater.setFaxNumber(attributes.get("fax_number"));
            }
            if (attributes.containsKey("building")) {
                personalDataUpdater.setBuilding(attributes.get("building"));
            }
            if (attributes.containsKey("room")) {
                personalDataUpdater.setRoom(attributes.get("room"));
            }
            if (attributes.containsKey("address")) {
                personalDataUpdater.setAddress(attributes.get("address"));
            }
            if (attributes.containsKey("zipcode")) {
                personalDataUpdater.setZipCode(attributes.get("zipcode"));
            }
            if (attributes.containsKey("city")) {
                personalDataUpdater.setCity(attributes.get("city"));
            }
            if (attributes.containsKey("state")) {
                personalDataUpdater.setState(attributes.get("state"));
            }
            if (attributes.containsKey("country")) {
                personalDataUpdater.setCountry(attributes.get("country"));
            }
            if (attributes.containsKey("website")) {
                personalDataUpdater.setWebsite(attributes.get("website"));
            }
            UserUpdater userUpdater = new UserUpdater().setPersonalContactData(personalDataUpdater).setProfessionalContactData(new ContactDataUpdater());
            TenantAPIAccessor.getIdentityAPI((APISession)this.getEngineSession()).updateUser(id.toLong().longValue(), userUpdater);
            return this.get(id);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public PersonalContactDataItem add(PersonalContactDataItem item) {
        APIID idUser = item.getId();
        Map<String, String> attributes = item.getAttributes();
        return this.update(idUser, (Map)attributes);
    }

    @Override
    protected PersonalContactDataItem convertEngineToConsoleItem(ContactData item) {
        throw new RuntimeException("Use ContactDataConverter instead!");
    }

    private ContactDataConverter<PersonalContactDataItem> createContactDataItemConverter(final APIID id) {
        return new ContactDataConverter<PersonalContactDataItem>(){

            @Override
            public PersonalContactDataItem createContactDataItem() {
                return new PersonalContactDataItem();
            }

            @Override
            public void setContactId(PersonalContactDataItem contactData) {
                contactData.setId(id);
            }
        };
    }
}

