/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.organization;

import java.util.Map;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.console.common.server.utils.IconDescriptor;
import org.bonitasoft.engine.identity.UserUpdater;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;

public class UserUpdaterConverter {
    public UserUpdater convert(Map<String, String> attributes, BonitaHomeFolderAccessor bonitaHomeFolderAccessor) {
        UserUpdater userUpdater = new UserUpdater();
        if (attributes.containsKey("firstname")) {
            userUpdater.setFirstName(attributes.get("firstname"));
        }
        if (attributes.containsKey("lastname")) {
            userUpdater.setLastName(attributes.get("lastname"));
        }
        if (attributes.containsKey("password")) {
            userUpdater.setPassword(attributes.get("password"));
        }
        if (attributes.containsKey("userName")) {
            userUpdater.setUserName(attributes.get("userName"));
        }
        if (attributes.containsKey("manager_id")) {
            Long managerId = this.getManagerId(attributes);
            userUpdater.setManagerId(managerId.longValue());
        }
        if (!StringUtil.isBlank(attributes.get("icon"))) {
            IconDescriptor iconDescriptor = bonitaHomeFolderAccessor.getIconFromFileSystem(attributes.get("icon"));
            userUpdater.setIcon(iconDescriptor.getFilename(), iconDescriptor.getContent());
        }
        if (attributes.containsKey("title")) {
            userUpdater.setTitle(attributes.get("title"));
        }
        if (attributes.containsKey("job_title")) {
            userUpdater.setJobTitle(attributes.get("job_title"));
        }
        if (attributes.containsKey("enabled")) {
            userUpdater.setEnabled("true".equals(attributes.get("enabled")));
        }
        return userUpdater;
    }

    private Long getManagerId(Map<String, String> attributes) {
        try {
            return Long.valueOf(attributes.get("manager_id"));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }
}

