/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.utils;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.web.rest.server.datastore.converter.AttributeConverter;
import org.bonitasoft.web.rest.server.datastore.converter.EmptyAttributeConverter;
import org.bonitasoft.web.rest.server.datastore.utils.Sort;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;

public class Sorts {
    private final List<Sort> sorts;

    public Sorts(String orders, AttributeConverter converter) {
        this.sorts = this.parseOrders(orders, converter);
    }

    public Sorts(String orders) {
        this(orders, new EmptyAttributeConverter());
    }

    private List<Sort> parseOrders(String orders, AttributeConverter converter) {
        if (StringUtil.isBlank(orders)) {
            return new ArrayList<Sort>();
        }
        return this.buildSortList(orders, converter);
    }

    private List<Sort> buildSortList(String orders, AttributeConverter converter) {
        ArrayList<Sort> sorts = new ArrayList<Sort>();
        for (String order : orders.split(",")) {
            sorts.add(new Sort(order, converter));
        }
        return sorts;
    }

    public List<Sort> asList() {
        return this.sorts;
    }
}

