/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.engineclient;

import java.io.Serializable;
import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.process.ProcessActivationException;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessExecutionException;
import org.bonitasoft.engine.bpm.process.ProcessInstance;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.identity.UserNotFoundException;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APINotFoundException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APITooManyRequestException;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;

public class CaseEngineClient {
    protected final ProcessAPI processAPI;

    public CaseEngineClient(ProcessAPI processAPI) {
        this.processAPI = processAPI;
    }

    public ProcessInstance start(long userId, long processId) {
        return this.start(userId, processId, null);
    }

    public ProcessInstance start(long userId, long processId, Map<String, Serializable> variables) {
        try {
            if (userId != -1L) {
                if (variables == null || variables.isEmpty()) {
                    return this.processAPI.startProcess(userId, processId);
                }
                return this.processAPI.startProcess(userId, processId, variables);
            }
            if (variables == null || variables.isEmpty()) {
                return this.processAPI.startProcess(processId);
            }
            return this.processAPI.startProcess(processId, variables);
        }
        catch (ProcessDefinitionNotFoundException e) {
            throw new APINotFoundException(new T_("Can't start process, process %processId% not found", new Arg("processId", processId)), (Throwable)e);
        }
        catch (ProcessActivationException e) {
            throw new APIException(new T_("Can't start process, process %processId% is not enabled", new Arg("processId", processId)), (Throwable)e);
        }
        catch (ProcessExecutionException e) {
            if (e.getRetryAfter() != -1L) {
                throw new APITooManyRequestException(new T_("Error occurred when starting process %processId%. Case creation limit reached.", new Arg("processId", processId)), e.getRetryAfter());
            }
            throw new APIException(new T_("Error occurred when starting process %processId%", new Arg("processId", processId)), (Throwable)e);
        }
        catch (UserNotFoundException e) {
            throw new APIException(new T_("Can't start process %processId%, user %userId% not found", new Arg("processId", processId), new Arg("userId", userId)), (Throwable)e);
        }
    }

    public long countOpenedCases() {
        SearchOptions search = new SearchOptionsBuilder(0, 0).done();
        try {
            return this.processAPI.searchOpenProcessInstances(search).getCount();
        }
        catch (SearchException e) {
            throw new APIException("Error when counting opened cases", (Throwable)e);
        }
    }
}

