/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.engineclient;

import java.util.List;
import org.bonitasoft.engine.api.GroupAPI;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.identity.Group;
import org.bonitasoft.engine.identity.GroupCreator;
import org.bonitasoft.engine.identity.GroupNotFoundException;
import org.bonitasoft.engine.identity.GroupUpdater;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIForbiddenException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APINotFoundException;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class GroupEngineClient {
    private final GroupAPI groupAPI;

    protected GroupEngineClient(GroupAPI groupAPI) {
        this.groupAPI = groupAPI;
    }

    public Group get(Long groupId) {
        try {
            return this.groupAPI.getGroup(groupId.longValue());
        }
        catch (GroupNotFoundException e) {
            throw new APIItemNotFoundException("group", APIID.makeAPIID(groupId));
        }
    }

    public Group getGroupByPath(String groupPath) {
        try {
            return this.groupAPI.getGroupByPath(groupPath);
        }
        catch (GroupNotFoundException e) {
            throw new APIItemNotFoundException("group", APIID.makeAPIID(groupPath));
        }
    }

    public String getPath(String groupId) {
        try {
            return this.groupAPI.getGroup(this.parseId(groupId)).getPath();
        }
        catch (GroupNotFoundException e) {
            throw new APINotFoundException(new T_("Unable to get group path, group not found"));
        }
    }

    private long parseId(String groupId) {
        try {
            return Long.parseLong(groupId);
        }
        catch (NumberFormatException e) {
            throw new APIException("Illegal argument, groupId must be a number");
        }
    }

    public void delete(List<Long> groupIds) {
        try {
            this.groupAPI.deleteGroups(groupIds);
        }
        catch (DeletionException e) {
            if (e.getCause() instanceof GroupNotFoundException) {
                throw new APIItemNotFoundException("group");
            }
            throw new APIException(new T_("Error when deleting groups"), (Throwable)e);
        }
    }

    public Group update(long groupId, GroupUpdater groupUpdater) {
        try {
            return this.groupAPI.updateGroup(groupId, groupUpdater);
        }
        catch (GroupNotFoundException e) {
            throw new APIItemNotFoundException("group", APIID.makeAPIID(groupId));
        }
        catch (UpdateException e) {
            throw new APIException(new T_("Error when updating group"), (Throwable)e);
        }
        catch (AlreadyExistsException e) {
            throw new APIForbiddenException(new T_("A group with the name %groupName% already exists", new Arg("groupName", groupUpdater.getFields().get(GroupCreator.GroupField.NAME))));
        }
    }

    public Group create(GroupCreator groupCreator) {
        try {
            return this.groupAPI.createGroup(groupCreator);
        }
        catch (AlreadyExistsException e) {
            throw new APIForbiddenException(new T_("Can't create group. Group '%groupName%' already exists", new Arg("groupName", groupCreator.getFields().get(GroupCreator.GroupField.NAME))));
        }
        catch (CreationException e) {
            throw new APIException(new T_("Error when creating group"), (Throwable)e);
        }
    }
}

