/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.engineclient;

import java.io.Serializable;
import java.util.List;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.bonitasoft.engine.bpm.process.ProcessDefinition;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessDeployException;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfo;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfoUpdater;
import org.bonitasoft.engine.bpm.process.V6FormDeployException;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.ProcessInstanceHierarchicalDeletionException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIForbiddenException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APINotFoundException;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessEngineClient {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ProcessEngineClient.class.getName());
    private static final int DELETE_PROCESS_BUNCH_SIZE = 100;
    protected final ProcessAPI processAPI;

    public ProcessEngineClient(ProcessAPI processAPI) {
        this.processAPI = processAPI;
    }

    public ProcessDeploymentInfo getProcessDeploymentInfo(long processId) {
        try {
            return this.getProcessApi().getProcessDeploymentInfo(processId);
        }
        catch (ProcessDefinitionNotFoundException e) {
            LOGGER.debug("Unable to find process with id " + processId);
            throw new APIItemNotFoundException("process", APIID.makeAPIID(processId));
        }
    }

    public ProcessAPI getProcessApi() {
        return this.processAPI;
    }

    public ProcessDefinition deploy(BusinessArchive businessArchive) {
        try {
            return this.getProcessApi().deploy(businessArchive);
        }
        catch (AlreadyExistsException e) {
            DesignProcessDefinition processDefinition = businessArchive.getProcessDefinition();
            throw new APIForbiddenException(new T_("Process %appName% in version %version% already exists", new Arg("appName", processDefinition.getName()), new Arg("version", processDefinition.getVersion())), (Throwable)e);
        }
        catch (V6FormDeployException e) {
            DesignProcessDefinition processDefinition = businessArchive.getProcessDefinition();
            throw new APIException(new T_("Process %appName% in version %version% contains 6.x Legacy artifacts (forms or case overview page). Those are based on Google Web Toolkit (GWT), a technology that is no longer supported by Bonita. To know more, check the documentation.", new Arg("appName", processDefinition.getName()), new Arg("version", processDefinition.getVersion())), (Throwable)e);
        }
        catch (ProcessDeployException e) {
            throw new APIException(new T_("Unable to deploy business archive"), (Throwable)e);
        }
    }

    public void enableProcess(long processId) {
        try {
            this.getProcessApi().enableProcess(processId);
        }
        catch (BonitaException e) {
            throw new APIException(new T_("Unable to enable process"), (Throwable)e);
        }
    }

    public void disableProcess(long processId) {
        try {
            this.getProcessApi().disableProcess(processId);
        }
        catch (BonitaException e) {
            throw new APIException(new T_("Unable to disable process"), (Throwable)e);
        }
    }

    public ProcessDeploymentInfo updateProcessDeploymentInfo(long processId, ProcessDeploymentInfoUpdater processDeploymentInfoUpdater) {
        try {
            this.getProcessApi().updateProcessDeploymentInfo(processId, processDeploymentInfoUpdater);
            return this.getProcessApi().getProcessDeploymentInfo(processId);
        }
        catch (BonitaException e) {
            throw new APIException(new T_("Error when updating process deployment informations"), (Throwable)e);
        }
    }

    public void deleteDisabledProcesses(List<Long> processIds) {
        try {
            for (Long id : processIds) {
                this.deleteProcessInstancesByBunch(id, 100, processIds);
                this.deleteArchivedProcessInstancesByBunch(id, 100, processIds);
                this.getProcessApi().deleteProcessDefinition(id.longValue());
            }
        }
        catch (BonitaException e) {
            if (e.getCause() instanceof ProcessDefinitionNotFoundException) {
                throw new APIItemNotFoundException("process");
            }
            throw new APIException("Error when deleting some of the processes in the list " + String.valueOf(processIds), (Throwable)e);
        }
    }

    public void deleteArchivedProcessInstancesByBunch(long processId, int bunchSize, List<Long> processesAllowedToBeDeletedIds) throws DeletionException, ProcessDefinitionNotFoundException {
        long numberOfDeletedArchivedProcessInstances = 0L;
        do {
            try {
                numberOfDeletedArchivedProcessInstances = this.getProcessApi().deleteArchivedProcessInstances(processId, 0, bunchSize);
            }
            catch (ProcessInstanceHierarchicalDeletionException e) {
                long parentProcessInstanceID = e.getProcessInstanceId();
                long parentProcessID = this.getProcessApi().getProcessDefinitionIdFromProcessInstanceId(parentProcessInstanceID);
                if (processesAllowedToBeDeletedIds.contains(parentProcessID)) {
                    this.deleteProcessInstancesByBunch(parentProcessID, 100, processesAllowedToBeDeletedIds);
                    continue;
                }
                LOGGER.warn("Process with ID " + processId + " cannot be deleted without also deleting its parent (" + parentProcessID + ").");
            }
        } while (numberOfDeletedArchivedProcessInstances >= (long)bunchSize);
    }

    public void deleteProcessInstancesByBunch(long processId, int bunchSize, List<Long> processesAllowedToBeDeletedIds) throws DeletionException, ProcessDefinitionNotFoundException {
        long numberOfDeletedProcessInstances = 0L;
        do {
            try {
                numberOfDeletedProcessInstances = this.getProcessApi().deleteProcessInstances(processId, 0, bunchSize);
            }
            catch (ProcessInstanceHierarchicalDeletionException e) {
                long parentProcessInstanceID = e.getProcessInstanceId();
                long parentProcessID = this.getProcessApi().getProcessDefinitionIdFromProcessInstanceId(parentProcessInstanceID);
                if (processesAllowedToBeDeletedIds.contains(parentProcessID)) {
                    this.deleteProcessInstancesByBunch(parentProcessID, 100, processesAllowedToBeDeletedIds);
                    continue;
                }
                LOGGER.warn("Process with ID " + processId + " cannot be deleted without also deleting its parent (" + parentProcessID + ").");
            }
        } while (numberOfDeletedProcessInstances >= (long)bunchSize);
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDefinitions(SearchOptions searchOptions) {
        try {
            return this.getProcessApi().searchProcessDeploymentInfos(searchOptions);
        }
        catch (SearchException e) {
            throw new APIException("Error when searching process definition", (Throwable)e);
        }
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDefinitionsSupervisedBy(long userId, SearchOptions searchOptions) {
        try {
            return this.getProcessApi().searchProcessDeploymentInfosSupervisedBy(userId, searchOptions);
        }
        catch (SearchException e) {
            throw new APIException("Error when searching process definition supervised by user " + userId, (Throwable)e);
        }
    }

    public SearchResult<ProcessDeploymentInfo> searchUncategorizedProcessDefinitionsUserCanStart(long userId, SearchOptions searchOptions) {
        try {
            return this.getProcessApi().searchUncategorizedProcessDeploymentInfosCanBeStartedBy(userId, searchOptions);
        }
        catch (SearchException e) {
            throw new APIException("Error when searching uncategorized process definition which can be started by user " + userId, (Throwable)e);
        }
    }

    public SearchResult<ProcessDeploymentInfo> searchRecentlyStartedProcessDefinitions(long userId, SearchOptions searchOptions) {
        try {
            return this.getProcessApi().searchProcessDeploymentInfosStartedBy(userId, searchOptions);
        }
        catch (SearchException e) {
            throw new APIException("Error when searching recently started process by user " + userId, (Throwable)e);
        }
    }

    public long countResolvedProcesses() {
        SearchOptionsBuilder builder = new SearchOptionsBuilder(0, 0);
        builder.filter("configurationState", (Serializable)((Object)"RESOLVED"));
        try {
            return this.getProcessApi().searchProcessDeploymentInfos(builder.done()).getCount();
        }
        catch (SearchException e) {
            throw new APIException("Error when counting resolved processes", (Throwable)e);
        }
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfosWithAssignedOrPendingHumanTasksSupervisedBy(long supervisorId, SearchOptions searchOptions) {
        try {
            return this.getProcessApi().searchProcessDeploymentInfosWithAssignedOrPendingHumanTasksSupervisedBy(supervisorId, searchOptions);
        }
        catch (SearchException e) {
            throw new APIException("Error when searching process user can start", (Throwable)e);
        }
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfosWithAssignedOrPendingHumanTasks(SearchOptions searchOptions) {
        try {
            return this.getProcessApi().searchProcessDeploymentInfosWithAssignedOrPendingHumanTasks(searchOptions);
        }
        catch (SearchException e) {
            throw new APIException("Error when searching process user can start", (Throwable)e);
        }
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfosWithAssignedOrPendingHumanTasksFor(long userId, SearchOptions searchOptions) {
        try {
            return this.getProcessApi().searchProcessDeploymentInfosWithAssignedOrPendingHumanTasksFor(userId, searchOptions);
        }
        catch (SearchException e) {
            throw new APIException("Error when searching process user can start", (Throwable)e);
        }
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfos(long userId, SearchOptions searchOptions) {
        try {
            return this.getProcessApi().searchProcessDeploymentInfosCanBeStartedBy(userId, searchOptions);
        }
        catch (SearchException e) {
            throw new APIException("Error when searching process user can start", (Throwable)e);
        }
    }

    public List<DataDefinition> getProcessDataDefinitions(long processId) {
        try {
            return this.processAPI.getProcessDataDefinitions(processId, 0, Integer.MAX_VALUE);
        }
        catch (ProcessDefinitionNotFoundException e) {
            throw new APINotFoundException(new T_("Unable to get process data definitions, process %processId% not found", new Arg("processId", processId)));
        }
    }
}

