/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.framework.exception;

import java.util.Arrays;
import java.util.List;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.http.JsonExceptionSerializer;
import org.bonitasoft.web.toolkit.client.ui.utils.ListUtils;

public class APIAttributesException
extends APIException {
    private static final long serialVersionUID = 7808353918962735013L;
    private final List<String> attributesNames;

    public APIAttributesException(List<String> attributesNames) {
        super((Throwable)null);
        this.attributesNames = attributesNames;
    }

    public APIAttributesException(String ... attributesNames) {
        super((Throwable)null);
        this.attributesNames = Arrays.asList(attributesNames);
    }

    public APIAttributesException(List<String> attributesNames, String message, Throwable cause) {
        super(message, cause);
        this.attributesNames = attributesNames;
    }

    public APIAttributesException(List<String> attributesNames, String message) {
        super(message);
        this.attributesNames = attributesNames;
    }

    public APIAttributesException(List<String> attributesNames, Throwable cause) {
        super(cause);
        this.attributesNames = attributesNames;
    }

    public List<String> getAttributesNames() {
        return this.attributesNames;
    }

    @Override
    protected JsonExceptionSerializer buildJson() {
        return super.buildJson().appendAttribute("attributesNames", this.getAttributesNames());
    }

    @Override
    protected String defaultMessage() {
        return "Malformed attributes : " + ListUtils.join(this.attributesNames, ", ");
    }
}

