/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.framework.json;

import java.util.Map;
import org.bonitasoft.web.toolkit.client.common.AbstractTreeNode;
import org.bonitasoft.web.toolkit.client.common.Tree;
import org.bonitasoft.web.toolkit.client.common.TreeIndexed;
import org.bonitasoft.web.toolkit.client.common.TreeLeaf;
import org.bonitasoft.web.toolkit.client.common.json.JSonUnserializer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JSonSimpleDeserializer
implements JSonUnserializer {
    private static JSonSimpleDeserializer INSTANCE = null;

    private static JSonSimpleDeserializer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JSonSimpleDeserializer();
        }
        return INSTANCE;
    }

    public static AbstractTreeNode<String> unserializeTree(String json) {
        return JSonSimpleDeserializer.getInstance()._unserializeTree(json);
    }

    @Override
    public AbstractTreeNode<String> _unserializeTree(String json) {
        try {
            if (json.length() == 0) {
                return null;
            }
            return this.unserializeTreeNode(new JSONParser().parse(json));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Can't parse JSon", e);
        }
    }

    private AbstractTreeNode<String> unserializeTreeNode(Object object) {
        if (object instanceof JSONObject) {
            return this.unserializeTreeNode((JSONObject)object);
        }
        if (object instanceof JSONArray) {
            return this.unserializeTreeNode((JSONArray)object);
        }
        if (object instanceof Boolean) {
            return new TreeLeaf<String>((Boolean)object != false ? "1" : "0");
        }
        return new TreeLeaf<String>(object.toString());
    }

    private TreeIndexed<String> unserializeTreeNode(JSONObject object) {
        TreeIndexed<String> result = new TreeIndexed<String>();
        for (Map.Entry entry : object.entrySet()) {
            result.addNode(entry.getKey().toString(), this.unserializeTreeNode(entry.getValue()));
        }
        return result;
    }

    private Tree<String> unserializeTreeNode(JSONArray array) {
        Tree<String> result = new Tree<String>();
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            result.addNode(this.unserializeTreeNode(array.get(i)));
        }
        return result;
    }
}

