/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.framework.utils;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIMalformedUrlException;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class RestRequestParser {
    public static final String SPRING_REST_SERVLET_NAME = "SpringRest";
    private final HttpServletRequest request;
    private String apiName;
    private String resourceName;
    private APIID resourceQualifiers;

    public RestRequestParser(HttpServletRequest request) {
        this.request = request;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public APIID getResourceQualifiers() {
        return this.resourceQualifiers;
    }

    public RestRequestParser invoke() {
        if (SPRING_REST_SERVLET_NAME.equals(this.request.getHttpServletMapping().getServletName())) {
            return this.parseSpringMVCAPIRequest();
        }
        return this.parseLegacyAPIRequest();
    }

    protected RestRequestParser parseLegacyAPIRequest() {
        String pathInfo = this.request.getPathInfo();
        if (pathInfo == null || pathInfo.split("/").length < 3) {
            pathInfo = this.request.getServletPath();
        }
        String[] path = pathInfo.split("/");
        return this.parseRequest(path, 1);
    }

    protected RestRequestParser parseSpringMVCAPIRequest() {
        Object apiPath = this.request.getServletPath();
        String pathInfo = this.request.getPathInfo();
        if (!StringUtils.isEmpty((CharSequence)pathInfo)) {
            apiPath = (String)apiPath + pathInfo;
        }
        String[] path = ((String)apiPath).split("/");
        return this.parseRequest(path, 2);
    }

    protected RestRequestParser parseRequest(String[] path, int indexOfAPINameSegment) {
        int minimalNumberOfPathSegments = indexOfAPINameSegment + 2;
        if (path.length < minimalNumberOfPathSegments) {
            throw new APIMalformedUrlException("Missing API or resource name [" + String.valueOf(this.request.getRequestURL()) + "]");
        }
        this.apiName = path[indexOfAPINameSegment];
        this.resourceName = path[indexOfAPINameSegment + 1];
        if (path.length > minimalNumberOfPathSegments) {
            List<String> pathList = Arrays.asList(path);
            this.resourceQualifiers = APIID.makeAPIID(pathList.subList(minimalNumberOfPathSegments, pathList.size()));
        } else {
            this.resourceQualifiers = null;
        }
        return this;
    }
}

