/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.common;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.web.toolkit.client.common.AbstractTreeNode;
import org.bonitasoft.web.toolkit.client.common.TreeLeaf;
import org.bonitasoft.web.toolkit.client.common.json.JSonSerializer;

public class TreeIndexed<VALUE_CLASS>
extends AbstractTreeNode<VALUE_CLASS> {
    protected Map<String, AbstractTreeNode<VALUE_CLASS>> children = new HashMap<String, AbstractTreeNode<VALUE_CLASS>>();

    public TreeIndexed() {
    }

    public TreeIndexed(AbstractTreeNode<VALUE_CLASS> parent, Map<String, VALUE_CLASS> map) {
        this(parent);
        this.addValues(map);
    }

    public TreeIndexed(AbstractTreeNode<VALUE_CLASS> parent) {
        super(parent);
    }

    public void addNode(String key, AbstractTreeNode<VALUE_CLASS> node) {
        if (node == null) {
            return;
        }
        node.setParent(this);
        this.children.put(key, node);
    }

    public void addValue(String key, VALUE_CLASS value) {
        if (value != null) {
            this.addNode(key, new TreeLeaf<VALUE_CLASS>(this, value));
        }
    }

    public void addValues(Map<String, VALUE_CLASS> values) {
        if (values != null) {
            for (String key : values.keySet()) {
                this.addValue(key, values.get(key));
            }
        }
    }

    public LinkedHashMap<String, VALUE_CLASS> getValues() {
        LinkedHashMap values = new LinkedHashMap();
        for (String key : this.children.keySet()) {
            AbstractTreeNode<VALUE_CLASS> node = this.children.get(key);
            if (!(node instanceof TreeLeaf)) continue;
            values.put(key, ((TreeLeaf)node).getValue());
        }
        return values;
    }

    public AbstractTreeNode<VALUE_CLASS> get(String key) {
        return this.children.get(key);
    }

    public Set<String> keySet() {
        return this.children.keySet();
    }

    public VALUE_CLASS getValue(String key) {
        AbstractTreeNode<VALUE_CLASS> node = this.children.get(key);
        if (node instanceof TreeLeaf) {
            return ((TreeLeaf)node).getValue();
        }
        return null;
    }

    public String toString() {
        return this.children.toString();
    }

    public int size() {
        return this.children.size();
    }

    @Override
    public String toJson() {
        return JSonSerializer.serializeMap(this.children);
    }

    @Override
    public TreeIndexed<VALUE_CLASS> copy() {
        TreeIndexed<VALUE_CLASS> result = new TreeIndexed<VALUE_CLASS>();
        for (String key : this.children.keySet()) {
            result.addNode(key, this.children.get(key).copy());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreeIndexed)) {
            return false;
        }
        TreeIndexed tree = (TreeIndexed)o;
        if (tree.size() != this.size()) {
            return false;
        }
        for (String key : this.keySet()) {
            if (this.get(key).equals(tree.get(key))) continue;
            return false;
        }
        for (String key : tree.keySet()) {
            if (tree.get(key).equals(this.get(key))) continue;
            return false;
        }
        return true;
    }

    public Map<String, AbstractTreeNode<VALUE_CLASS>> getNodes() {
        return this.children;
    }
}

