/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.common.exception.api;

import org.bonitasoft.web.toolkit.client.common.exception.http.JsonExceptionSerializer;
import org.bonitasoft.web.toolkit.client.common.exception.http.ServerException;
import org.bonitasoft.web.toolkit.client.common.i18n.AbstractI18n;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;
import org.bonitasoft.web.toolkit.client.common.json.JsonSerializable;

public class APIException
extends ServerException
implements JsonSerializable {
    private static final long serialVersionUID = 1820639344042666872L;
    private AbstractI18n.LOCALE locale;
    private String api = "...";
    private String resource = "...";
    private T_ localizedMessage;

    protected APIException() {
    }

    public APIException(String message, Throwable cause) {
        super(message, cause);
    }

    public APIException(String message) {
        super(message);
    }

    public APIException(Throwable cause) {
        super(cause);
    }

    public APIException(T_ localizedMessage, Throwable cause) {
        super(cause);
        this.localizedMessage = localizedMessage;
    }

    public APIException(T_ localizedMessage) {
        this.localizedMessage = localizedMessage;
    }

    public String getApi() {
        return this.api;
    }

    public APIException setApi(String api) {
        this.api = api;
        return this;
    }

    public String getResource() {
        return this.resource;
    }

    public APIException setResource(String resource) {
        this.resource = resource;
        return this;
    }

    @Override
    protected JsonExceptionSerializer buildJson() {
        return super.buildJson().appendAttribute("api", this.getApi()).appendAttribute("resource", this.getResource());
    }

    @Override
    protected String defaultMessage() {
        return "The API \"" + this.getApi() + "#" + this.getResource() + "\" has encountered an unknown error";
    }

    public void setLocale(AbstractI18n.LOCALE locale) {
        this.locale = locale;
    }

    @Override
    public String getMessage() {
        if (this.locale != null && this.localizedMessage != null) {
            return this.localizedMessage.localize(this.locale);
        }
        return super.getMessage();
    }
}

