/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.common.json;

public class JSonUtil {
    public static String quote(String value) {
        return JSonUtil.quoteInternal(value).toString();
    }

    public static StringBuilder quoteInternal(String value) {
        return new StringBuilder("\"").append(JSonUtil.escape(value)).append("\"");
    }

    public static String escape(String string) {
        return JSonUtil.escapeInternal(string).toString();
    }

    private static StringBuilder escapeInternal(String string) {
        if (string == null || string.length() == 0) {
            return new StringBuilder();
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '<': 
                case '>': 
                case '\\': {
                    sb.append(JSonUtil.convertToUnicodeInternal(c));
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        sb.append(JSonUtil.convertToUnicodeInternal(c));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        return new StringBuilder(sb);
    }

    private static StringBuffer convertToUnicodeInternal(char character) {
        StringBuilder hexString = new StringBuilder("000").append(Integer.toHexString(character));
        return new StringBuffer("\\u").append(hexString.substring(hexString.length() - 4));
    }
}

