/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.common.texttemplate;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;

public class TextTemplate {
    private String template = null;
    private List<String> expectedParameters = null;
    private final Pattern regex = Pattern.compile("%(.*?)%");

    public TextTemplate(String template) {
        this.template = template;
    }

    public String toString(Map<String, String> data) {
        String result = this.template;
        for (Map.Entry<String, String> entry : data.entrySet()) {
            result = result.replaceAll("%" + entry.getKey() + "%", entry.getValue() != null ? entry.getValue() : "");
        }
        return result;
    }

    public String toString(Arg ... parameters) {
        String result = this.template;
        for (Arg parameter : parameters) {
            result = result.replaceAll("%" + parameter.getName() + "%", parameter.getValue());
        }
        return result;
    }

    public String toString(List<Arg> parameters) {
        String result = this.template;
        for (Arg parameter : parameters) {
            result = result.replaceAll("%" + parameter.getName() + "%", parameter.getValue());
        }
        return result;
    }

    public String toString() {
        return this.template;
    }

    public List<String> getExpectedParameters() {
        if (this.expectedParameters == null) {
            this.parseExpectedParameters();
        }
        return this.expectedParameters;
    }

    private void parseExpectedParameters() {
        this.expectedParameters = new LinkedList<String>();
        Matcher matcher = this.regex.matcher(this.template);
        while (matcher.find()) {
            this.expectedParameters.add(matcher.group(1));
        }
    }
}

