/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.SchemaFactory;
import org.bonitasoft.engine.identity.xml.Organization;
import org.glassfish.hk2.osgiresourcelocator.ResourceFinder;
import org.xml.sax.SAXException;

public class OrganizationParser {
    public static final String ORGANIZATION_XML_SCHEMA = "http://documentation.bonitasoft.com/organization-xml-schema";
    public static final String ORGANIZATION_XML_VERSION = "1.1";
    public static final String ORGANIZATION_NAMESPACE = "http://documentation.bonitasoft.com/organization-xml-schema/1.1";
    private static final String ORGANIZATION_XSD = "/organization.xsd";
    private final JAXBContext jaxbContext;

    public OrganizationParser() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Organization.class});
        }
        catch (Exception e) {
            throw new DataBindingException((Throwable)e);
        }
    }

    public Organization convert(String organizationContent) throws JAXBException {
        if (!organizationContent.contains(ORGANIZATION_NAMESPACE)) {
            organizationContent = organizationContent.replace(ORGANIZATION_XML_SCHEMA, ORGANIZATION_NAMESPACE);
        }
        return (Organization)this.createUnmarshaller().unmarshal((Reader)new StringReader(organizationContent));
    }

    public String convert(Organization organization) throws JAXBException {
        StringWriter writer = new StringWriter();
        this.createMarshaller().marshal((Object)organization, (Writer)writer);
        return writer.toString();
    }

    private Unmarshaller createUnmarshaller() throws JAXBException {
        try {
            URL organizationXsd = Optional.ofNullable(ResourceFinder.findEntry((String)ORGANIZATION_XSD)).orElseGet(() -> OrganizationParser.class.getResource(ORGANIZATION_XSD));
            Unmarshaller jaxbUnmarshaller = this.jaxbContext.createUnmarshaller();
            jaxbUnmarshaller.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(organizationXsd));
            return jaxbUnmarshaller;
        }
        catch (SAXException e) {
            throw new JAXBException((Throwable)e);
        }
    }

    private Marshaller createMarshaller() throws JAXBException {
        Marshaller jaxbMarshaller = this.jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        jaxbMarshaller.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
        return jaxbMarshaller;
    }
}

