/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.tomcat.jta;

import com.arjuna.ats.arjuna.common.CoreEnvironmentBeanException;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.coordinator.TransactionReaper;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.internal.arjuna.recovery.AtomicActionRecoveryModule;
import com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner;
import com.arjuna.ats.internal.jta.recovery.arjunacore.JTANodeNameXAResourceOrphanFilter;
import com.arjuna.ats.internal.jta.recovery.arjunacore.JTATransactionLogXAResourceOrphanFilter;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jdbc.TransactionalDriver;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;

public class TransactionLifecycleListener
implements LifecycleListener {
    private static final Logger LOGGER = Logger.getLogger(TransactionLifecycleListener.class.getName());
    private static final String DEFAULT_NODE_IDENTIFIER = "1";
    private static final List<String> DEFAULT_RECOVERY_MODULES = Arrays.asList(AtomicActionRecoveryModule.class.getName(), XARecoveryModule.class.getName());
    private static final List<String> DEFAULT_ORPHAN_FILTERS = Arrays.asList(JTATransactionLogXAResourceOrphanFilter.class.getName(), JTANodeNameXAResourceOrphanFilter.class.getName());
    private static final List<String> DEFAULT_EXPIRY_SCANNERS = Collections.singletonList(ExpiredTransactionStatusManagerScanner.class.getName());

    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_start".equals(event.getType())) {
            LOGGER.fine("Initializing Narayana");
            this.initNodeIdentifier();
            this.initRecoveryModules();
            this.initOrphanFilters();
            this.initExpiryScanners();
            RecoveryManager.manager();
            TxControl.enable();
            TransactionReaper.instantiate();
        } else if ("after_stop".equals(event.getType())) {
            LOGGER.fine("Disabling Narayana");
            TransactionReaper.terminate((boolean)false);
            TxControl.disable();
            RecoveryManager.manager().terminate();
            Collections.list(DriverManager.getDrivers()).stream().filter(d -> d instanceof TransactionalDriver).forEach(d -> {
                try {
                    DriverManager.deregisterDriver(d);
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                }
            });
        }
    }

    private void initNodeIdentifier() {
        if (arjPropertyManager.getCoreEnvironmentBean().getNodeIdentifier() == null) {
            LOGGER.warning("Node identifier was not set. Setting it to the default value: 1");
            try {
                arjPropertyManager.getCoreEnvironmentBean().setNodeIdentifier(DEFAULT_NODE_IDENTIFIER);
            }
            catch (CoreEnvironmentBeanException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
        jtaPropertyManager.getJTAEnvironmentBean().setXaRecoveryNodes(Collections.singletonList(arjPropertyManager.getCoreEnvironmentBean().getNodeIdentifier()));
    }

    private void initRecoveryModules() {
        if (!recoveryPropertyManager.getRecoveryEnvironmentBean().getRecoveryModuleClassNames().isEmpty()) {
            return;
        }
        LOGGER.fine("Recovery modules were not enabled. Enabling default modules: " + String.valueOf(DEFAULT_RECOVERY_MODULES));
        recoveryPropertyManager.getRecoveryEnvironmentBean().setRecoveryModuleClassNames(DEFAULT_RECOVERY_MODULES);
    }

    private void initOrphanFilters() {
        if (!jtaPropertyManager.getJTAEnvironmentBean().getXaResourceOrphanFilterClassNames().isEmpty()) {
            return;
        }
        LOGGER.fine("Orphan filters were not enabled. Enabling default filters: " + String.valueOf(DEFAULT_ORPHAN_FILTERS));
        jtaPropertyManager.getJTAEnvironmentBean().setXaResourceOrphanFilterClassNames(DEFAULT_ORPHAN_FILTERS);
    }

    private void initExpiryScanners() {
        if (!recoveryPropertyManager.getRecoveryEnvironmentBean().getExpiryScannerClassNames().isEmpty()) {
            return;
        }
        LOGGER.fine("Expiry scanners were not enabled. Enabling default scanners: " + String.valueOf(DEFAULT_EXPIRY_SCANNERS));
        recoveryPropertyManager.getRecoveryEnvironmentBean().setExpiryScannerClassNames(DEFAULT_EXPIRY_SCANNERS);
    }
}

