/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.tomcat.jta.internal;

import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;
import org.apache.tomcat.dbcp.dbcp2.BasicDataSource;
import org.apache.tomcat.dbcp.dbcp2.BasicDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp2.managed.BasicManagedDataSource;
import org.jboss.narayana.tomcat.jta.internal.XADataSourceIsSameRMOverride;

public final class PoolingDataSourceFactory {
    private static final Logger LOGGER = Logger.getLogger(PoolingDataSourceFactory.class.getName());
    private static final String PROP_USERNAME = "username";
    private static final String PROP_PASSWORD = "password";

    static XAResourceRecoveryHelper getXAResourceRecoveryHelper(final XADataSource xaDataSource, final Properties properties) {
        return new XAResourceRecoveryHelper(){
            private final Object lock = new Object();
            private XAConnection connection;

            public boolean initialise(String p) throws Exception {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized XAResource[] getXAResources() throws Exception {
                Object object = this.lock;
                synchronized (object) {
                    this.initialiseConnection();
                    try {
                        return new XAResource[]{this.connection.getXAResource()};
                    }
                    catch (SQLException ex) {
                        return new XAResource[0];
                    }
                }
            }

            private void initialiseConnection() throws SQLException {
                if (this.connection != null) {
                    try {
                        LOGGER.fine("XAResourceRecoveryHelper : Detected a connection during XARecovery" + String.valueOf(this.connection) + " attempting to close it properly & generating a new one");
                        this.connection.close();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "XAResourceRecoveryHelper : The connection could not close properly, generating a new one", e);
                    }
                    finally {
                        this.connection = null;
                    }
                }
                String user = properties.getProperty(PoolingDataSourceFactory.PROP_USERNAME);
                String password = properties.getProperty(PoolingDataSourceFactory.PROP_PASSWORD);
                this.connection = user != null && password != null ? xaDataSource.getXAConnection(user, password) : xaDataSource.getXAConnection();
                this.connection.addConnectionEventListener(new ConnectionEventListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void connectionClosed(ConnectionEvent event) {
                        LOGGER.warning("The connection was closed: " + String.valueOf(connection));
                        Object object = lock;
                        synchronized (object) {
                            connection = null;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void connectionErrorOccurred(ConnectionEvent event) {
                        LOGGER.warning("A connection error occurred: " + String.valueOf(connection));
                        Object object = lock;
                        synchronized (object) {
                            try {
                                connection.close();
                            }
                            catch (SQLException e) {
                                LOGGER.warning("Could not close failing connection: " + String.valueOf(connection));
                            }
                            connection = null;
                        }
                    }
                });
            }
        };
    }

    public static DataSource createPoolingDataSource(TransactionManager transactionManager, XADataSource xaDataSource, TransactionSynchronizationRegistry tsr, Properties properties) {
        if (transactionManager != null && xaDataSource != null) {
            String initialSize = properties.getProperty("initialSize");
            properties.remove("initialSize");
            BasicManagedDataSource mds = new BasicManagedDataSource();
            try {
                BasicDataSource ds = BasicDataSourceFactory.createDataSource((Properties)properties);
                for (Field field : ds.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    if (field.get(ds) == null || Modifier.isFinal(field.getModifiers())) continue;
                    field.set(mds, field.get(ds));
                }
                mds.setTransactionManager(transactionManager);
                if (xaDataSource.getClass().getName().toLowerCase().contains("oracle")) {
                    LOGGER.finest("using overridden implementation for isSameRM flag (Oracle)");
                    mds.setXaDataSourceInstance(XADataSourceIsSameRMOverride.overrideSameRM(xaDataSource));
                } else {
                    LOGGER.finest("using default XA datasource implementation");
                    mds.setXaDataSourceInstance(xaDataSource);
                }
                mds.setTransactionSynchronizationRegistry(tsr);
                if (initialSize != null) {
                    mds.setInitialSize(Integer.parseInt(initialSize));
                    if (mds.getInitialSize() > 0) {
                        mds.getLogWriter();
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            XARecoveryModule xaRecoveryModule = PoolingDataSourceFactory.getXARecoveryModule();
            if (xaRecoveryModule != null) {
                xaRecoveryModule.addXAResourceRecoveryHelper(PoolingDataSourceFactory.getXAResourceRecoveryHelper(xaDataSource, properties));
            }
            return mds;
        }
        return null;
    }

    private static XARecoveryModule getXARecoveryModule() {
        XARecoveryModule xaRecoveryModule = XARecoveryModule.getRegisteredXARecoveryModule();
        if (xaRecoveryModule != null) {
            return xaRecoveryModule;
        }
        throw new IllegalStateException("XARecoveryModule is not registered with recovery manager");
    }
}

