/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;

class BarResourceVisitor
extends SimpleFileVisitor<Path> {
    private BusinessArchive businessArchive;
    private final Path barRootFolder;
    private Path barResourceFolder;
    private int resourcesCount;

    public BarResourceVisitor(BusinessArchive businessArchive, Path barRootFolder) {
        this.businessArchive = businessArchive;
        this.barRootFolder = barRootFolder;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (dir.equals(Paths.get(String.valueOf(this.barRootFolder) + "/resources", new String[0]))) {
            this.barResourceFolder = dir;
            return FileVisitResult.CONTINUE;
        }
        if (dir.equals(this.barRootFolder)) {
            return FileVisitResult.CONTINUE;
        }
        if (this.barResourceFolder != null && dir.startsWith(this.barResourceFolder)) {
            return FileVisitResult.CONTINUE;
        }
        return FileVisitResult.SKIP_SUBTREE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Objects.requireNonNull(file);
        Objects.requireNonNull(attrs);
        this.businessArchive.addResource(this.barRootFolder.relativize(file).toString().replace(File.separator, "/"), Files.readAllBytes(file));
        ++this.resourcesCount;
        return FileVisitResult.CONTINUE;
    }

    public int getResourcesCount() {
        return this.resourcesCount;
    }
}

