/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.bonitasoft.engine.bpm.bar.actorMapping.ActorMapping;
import org.bonitasoft.engine.bpm.bar.form.model.FormMappingModel;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;

public class BusinessArchive
implements Serializable {
    private static final long serialVersionUID = -6410347766671025202L;
    private final Map<String, byte[]> resources = new HashMap<String, byte[]>();
    private DesignProcessDefinition processDefinition;
    private Map<String, String> parameters;
    private FormMappingModel formMappingModel = new FormMappingModel();
    private ActorMapping actorMapping = null;
    private boolean hasDependencyJars = true;

    public boolean hasDependencyJars() {
        return this.hasDependencyJars;
    }

    public void tagWithoutDependencyJars() {
        this.hasDependencyJars = false;
    }

    public ActorMapping getActorMapping() {
        return this.actorMapping;
    }

    public void setActorMapping(ActorMapping actorMapping) {
        this.actorMapping = actorMapping;
    }

    public DesignProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(DesignProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    public Map<String, String> getParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public byte[] getResource(String resourcePath) {
        return this.resources.get(resourcePath);
    }

    public Map<String, byte[]> getResources(String regex) {
        Pattern pattern = Pattern.compile(regex);
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> resource : this.getResources().entrySet()) {
            if (!pattern.matcher(resource.getKey()).matches()) continue;
            result.put(resource.getKey(), resource.getValue());
        }
        return result;
    }

    protected void addResource(String resourcePath, byte[] resourceData) {
        this.resources.put(resourcePath, resourceData);
    }

    public Map<String, byte[]> getResources() {
        return Collections.unmodifiableMap(this.resources);
    }

    public void setFormMappings(FormMappingModel formMappingModel) {
        this.formMappingModel = formMappingModel;
    }

    public FormMappingModel getFormMappingModel() {
        return this.formMappingModel;
    }
}

