/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.GenericFileContribution;

public class JarlessMarkerContribution
extends GenericFileContribution {
    protected static final String JAR_LESS_MARKER_RESOURCE_PATH = ".jarless";

    @Override
    public String getFileName() {
        return JAR_LESS_MARKER_RESOURCE_PATH;
    }

    @Override
    public String getName() {
        return this.getFileName();
    }

    @Override
    public boolean readFromBarFolder(BusinessArchive businessArchive, File barFolder) {
        Path file = barFolder.toPath().resolve(JAR_LESS_MARKER_RESOURCE_PATH);
        if (Files.exists(file, new LinkOption[0])) {
            businessArchive.tagWithoutDependencyJars();
            return true;
        }
        return false;
    }

    @Override
    public void saveToBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        if (!businessArchive.hasDependencyJars()) {
            Files.write(barFolder.toPath().resolve(JAR_LESS_MARKER_RESOURCE_PATH), new byte[0], new OpenOption[0]);
        }
    }

    @Override
    public boolean isMandatory() {
        return false;
    }
}

