/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm;

import java.util.List;
import java.util.regex.Pattern;
import org.bonitasoft.engine.bdm.BDMSimpleNameProvider;
import org.bonitasoft.engine.bdm.QueryGenerator;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.model.UniqueConstraint;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.model.field.RelationField;
import org.bonitasoft.engine.bdm.model.field.SimpleField;

public abstract class AbstractQueryGenerator
implements QueryGenerator {
    @Override
    public String createQueryNameForField(Field field) {
        this.checkObjectIsNotNull(field, "field cannot be null");
        return this.getQueryName(field.getName());
    }

    @Override
    public String getSelectAllQueryName() {
        return this.getQueryName(new String[0]);
    }

    @Override
    public String getQueryName(String ... fieldNames) {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(this.getQueryPrefix());
        if (fieldNames != null && fieldNames.length > 0) {
            String paramName;
            nameBuilder.append("By");
            int numberOfFields = fieldNames.length - 1;
            for (int i = 0; i < numberOfFields; ++i) {
                String fieldName = fieldNames[i];
                paramName = AbstractQueryGenerator.capitalize(fieldName);
                nameBuilder.append(paramName).append("And");
            }
            String fieldName = fieldNames[numberOfFields];
            paramName = AbstractQueryGenerator.capitalize(fieldName);
            nameBuilder.append(paramName);
        }
        return nameBuilder.toString();
    }

    protected abstract String getQueryPrefix();

    protected void checkObjectIsNotNull(Object object, String cause) {
        if (object == null) {
            throw new IllegalArgumentException(cause);
        }
    }

    protected void checkFieldIsNotACollection(Field field) {
        if (field.isCollection() != null && field.isCollection().booleanValue()) {
            throw new IllegalArgumentException("Collection field are not supported");
        }
    }

    @Override
    public Query createQueryForField(BusinessObject businessObject, Field field) {
        this.checkObjectIsNotNull(field, "field cannot be null");
        this.checkFieldIsNotACollection(field);
        Query query = new Query(this.createQueryNameForField(field), this.createQueryContentForField(businessObject.getQualifiedName(), field), this.getListReturnType());
        if (field instanceof SimpleField) {
            query.addQueryParameter(field.getName(), ((SimpleField)field).getType().getClazz().getName());
        }
        return query;
    }

    @Override
    public Query createSelectAllQueryForBusinessObject(BusinessObject businessObject) {
        this.checkObjectIsNotNull(businessObject, "businessObject cannot be null");
        String queryName = this.getSelectAllQueryName();
        String content = this.createSelectAllQueryContent(businessObject.getQualifiedName());
        return new Query(queryName, content, this.getListReturnType());
    }

    protected abstract String getListReturnType();

    @Override
    public Query createQueryForUniqueConstraint(BusinessObject businessObject, UniqueConstraint uniqueConstraint) {
        String name = this.createQueryNameForUniqueConstraint(uniqueConstraint);
        String content = this.createQueryContentForUniqueConstraint(businessObject.getQualifiedName(), uniqueConstraint);
        Query q = new Query(name, content, this.getQualifiedReturnType(businessObject));
        for (String fieldName : uniqueConstraint.getFieldNames()) {
            Field f = this.getField(fieldName, businessObject);
            if (!(f instanceof SimpleField)) continue;
            q.addQueryParameter(f.getName(), ((SimpleField)f).getType().getClazz().getName());
        }
        return q;
    }

    protected abstract String getQualifiedReturnType(BusinessObject var1);

    @Override
    public Query createQueryForLazyField(BusinessObject businessObject, RelationField relationField) {
        this.checkObjectIsNotNull(relationField, "relationField cannot be null");
        String name = this.createQueryNameForLazyField(businessObject, relationField);
        String content = this.createQueryContentForLazyField(businessObject.getQualifiedName(), relationField);
        Query q = new Query(name, content, relationField.getReference().getQualifiedName());
        if (Boolean.TRUE.equals(relationField.isCollection())) {
            q.setReturnType(List.class.getName());
        }
        q.addQueryParameter("persistenceId", Long.class.getName());
        return q;
    }

    private String createQueryContentForLazyField(String businessObjectName, RelationField relationField) {
        this.checkArgumentisNotEmpty(businessObjectName);
        this.checkObjectIsNotNull(relationField, "field cannot be null");
        String boName = BDMSimpleNameProvider.getSimpleBusinessObjectName(businessObjectName);
        String boAlias = boName.toLowerCase() + "_0";
        String fieldName = relationField.getName();
        String fieldAlias = fieldName.toLowerCase() + "_1";
        return String.format(this.getQueryContentForLazyField(), fieldAlias, boName, boAlias, boAlias, fieldName, fieldAlias, boAlias, "persistenceId", "persistenceId");
    }

    protected abstract String getQueryContentForLazyField();

    private String createQueryNameForLazyField(BusinessObject businessObject, RelationField relationField) {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(this.getQueryPrefix());
        nameBuilder.append(AbstractQueryGenerator.capitalize(relationField.getName()));
        nameBuilder.append("By");
        nameBuilder.append(BDMSimpleNameProvider.getSimpleBusinessObjectName(businessObject.getQualifiedName()));
        nameBuilder.append("PersistenceId");
        return nameBuilder.toString();
    }

    private Field getField(String fieldName, BusinessObject businessObject) {
        Field field = businessObject.getField(fieldName);
        if (field == null) {
            throw new IllegalArgumentException(fieldName + " doesn't exist in " + businessObject.getQualifiedName());
        }
        return field;
    }

    protected String createQueryContentForUniqueConstraint(String businessObjectName, UniqueConstraint uniqueConstraint) {
        this.checkArgumentisNotEmpty(businessObjectName);
        String simpleName = BDMSimpleNameProvider.getSimpleBusinessObjectName(businessObjectName);
        char alias = BDMSimpleNameProvider.getSimpleNameAlias(simpleName);
        String selectBlock = this.buildSelectFrom(simpleName, alias);
        StringBuilder builder = new StringBuilder();
        builder.append(selectBlock);
        builder.append(this.buildWhereAnd(alias, uniqueConstraint.getFieldNames()));
        return builder.toString();
    }

    private String buildWhereAnd(char prefix, List<String> parameterNames) {
        String paramName;
        StringBuilder builder = new StringBuilder("WHERE ");
        int numberOfParameters = parameterNames.size() - 1;
        for (int i = 0; i < numberOfParameters; ++i) {
            paramName = parameterNames.get(i);
            builder.append(this.buildCompareField(prefix, paramName));
            builder.append("AND ");
        }
        paramName = parameterNames.get(numberOfParameters);
        builder.append(this.buildCompareField(prefix, paramName));
        return builder.toString();
    }

    @Override
    public String createQueryNameForUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.checkObjectIsNotNull(uniqueConstraint, "uniqueConstraint cannot be null");
        return this.getQueryName(uniqueConstraint.getFieldNames().toArray(new String[0]));
    }

    protected String createQueryContentForField(String businessObjectName, Field field) {
        this.checkArgumentisNotEmpty(businessObjectName);
        this.checkObjectIsNotNull(field, "field cannot be null");
        String simpleName = BDMSimpleNameProvider.getSimpleBusinessObjectName(businessObjectName);
        char simpleNameAlias = BDMSimpleNameProvider.getSimpleNameAlias(simpleName);
        StringBuilder builder = new StringBuilder();
        builder.append(this.buildSelectFrom(simpleName, simpleNameAlias));
        builder.append(this.buildWhere(simpleNameAlias, field.getName()));
        builder.append(this.buildOrderBy(simpleNameAlias));
        return builder.toString();
    }

    protected String createSelectAllQueryContent(String businessObjectName) {
        this.checkArgumentisNotEmpty(businessObjectName);
        String simpleName = BDMSimpleNameProvider.getSimpleBusinessObjectName(businessObjectName);
        char alias = BDMSimpleNameProvider.getSimpleNameAlias(simpleName);
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildSelectFrom(simpleName, alias));
        sb.append(this.buildOrderBy(alias));
        return sb.toString();
    }

    private String buildOrderBy(char tablePrefix) {
        StringBuilder builder = new StringBuilder();
        this.addOrderBy(tablePrefix, builder);
        return builder.toString();
    }

    protected abstract void addOrderBy(char var1, StringBuilder var2);

    private String buildWhere(char prefix, String parameterName) {
        StringBuilder builder = new StringBuilder("WHERE ");
        builder.append(this.buildCompareField(prefix, parameterName));
        return builder.toString();
    }

    protected String buildCompareField(char prefix, String paramName) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix).append('.').append(paramName).append("= :").append(paramName).append("\n");
        return builder.toString();
    }

    protected void checkArgumentisNotEmpty(String argument) {
        this.checkObjectIsNotNull(argument, "businessObjectName is null");
        if (argument.isEmpty()) {
            throw new IllegalArgumentException("businessObjectName is empty");
        }
    }

    public String buildSelectFrom(String simpleName, char simpleNameAlias) {
        StringBuilder builder = new StringBuilder();
        this.buildSelect(simpleNameAlias, builder);
        builder.append("FROM ").append(simpleName).append(' ').append(simpleNameAlias).append("\n");
        return builder.toString();
    }

    protected abstract void buildSelect(char var1, StringBuilder var2);

    private static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return Pattern.compile("(^|\\s)[a-z]").matcher(str).replaceAll(m -> m.group().toUpperCase());
    }
}

