/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm;

import org.bonitasoft.engine.bdm.AbstractQueryGenerator;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.model.UniqueConstraint;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.model.field.RelationField;

public class CountQueryGenerator
extends AbstractQueryGenerator {
    @Override
    public String getQueryPrefix() {
        return "countForFind";
    }

    @Override
    public Query createQueryForPersistenceId(BusinessObject businessObject) {
        return null;
    }

    @Override
    protected String getQualifiedReturnType(BusinessObject businessObject) {
        return Long.class.getName();
    }

    @Override
    protected String getQueryContentForLazyField() {
        return "SELECT COUNT(%s) FROM %s %s JOIN %s.%s as %s WHERE %s.%s= :%s";
    }

    @Override
    protected void addOrderBy(char tablePrefix, StringBuilder builder) {
    }

    @Override
    public void buildSelect(char simpleNameAlias, StringBuilder builder) {
        builder.append("SELECT ").append("COUNT").append("(").append(simpleNameAlias).append(")").append("\n");
    }

    @Override
    public String getListReturnType() {
        return Long.class.getName();
    }

    @Override
    public Query createQueryForLazyField(BusinessObject businessObject, RelationField relationField) {
        if (Boolean.TRUE.equals(relationField.isCollection())) {
            return super.createQueryForLazyField(businessObject, relationField);
        }
        return null;
    }

    @Override
    public Query createQueryForUniqueConstraint(BusinessObject businessObject, UniqueConstraint uniqueConstraint) {
        return null;
    }

    @Override
    public Query createQueryForField(BusinessObject businessObject, Field field) {
        if (this.hasUniqueConstraintOnField(businessObject, field)) {
            return null;
        }
        return super.createQueryForField(businessObject, field);
    }

    private boolean hasUniqueConstraintOnField(BusinessObject businessObject, Field field) {
        for (UniqueConstraint uniqueConstraint : businessObject.getUniqueConstraints()) {
            if (uniqueConstraint.getFieldNames().size() != 1 || !uniqueConstraint.getFieldNames().contains(field.getName())) continue;
            return true;
        }
        return false;
    }
}

