/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.Index;
import org.bonitasoft.engine.bdm.model.UniqueConstraint;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BusinessObjectModel {
    public static final String CURRENT_MODEL_VERSION = "1.0";
    @XmlElementWrapper(name="businessObjects", required=true)
    @XmlElement(name="businessObject", required=true)
    private List<BusinessObject> businessObjects = new ArrayList<BusinessObject>();
    @XmlAttribute(name="modelVersion", required=false)
    private String modelVersion;
    @XmlAttribute(name="productVersion", required=false)
    private String productVersion;

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public List<BusinessObject> getBusinessObjects() {
        return this.businessObjects;
    }

    public void setBusinessObjects(List<BusinessObject> businessObjects) {
        this.businessObjects = businessObjects;
    }

    public void addBusinessObject(BusinessObject businessObject) {
        this.businessObjects.add(businessObject);
    }

    public Set<String> getBusinessObjectsClassNames() {
        HashSet<String> set = new HashSet<String>();
        for (BusinessObject o : this.businessObjects) {
            set.add(o.getQualifiedName());
        }
        return set;
    }

    public List<BusinessObject> getReferencedBusinessObjectsByComposition() {
        ArrayList<BusinessObject> refs = new ArrayList<BusinessObject>();
        for (BusinessObject bo : this.businessObjects) {
            refs.addAll(bo.getReferencedBusinessObjectsByComposition());
        }
        return refs;
    }

    public List<UniqueConstraint> getUniqueConstraints() {
        ArrayList<UniqueConstraint> constraints = new ArrayList<UniqueConstraint>();
        for (BusinessObject bo : this.businessObjects) {
            constraints.addAll(bo.getUniqueConstraints());
        }
        return constraints;
    }

    public List<Index> getIndexes() {
        ArrayList<Index> indexes = new ArrayList<Index>();
        for (BusinessObject bo : this.businessObjects) {
            indexes.addAll(bo.getIndexes());
        }
        return indexes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessObjectModel that = (BusinessObjectModel)o;
        return Objects.equals(this.businessObjects, that.businessObjects) && Objects.equals(this.modelVersion, that.modelVersion) && Objects.equals(this.productVersion, that.productVersion);
    }

    public int hashCode() {
        return Objects.hash(this.businessObjects, this.modelVersion, this.productVersion);
    }

    public String toString() {
        return new StringJoiner(", ", BusinessObjectModel.class.getSimpleName() + "[", "]").add("businessObjects=" + String.valueOf(this.businessObjects)).toString();
    }
}

