/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.bonitasoft.engine.bdm.model.QueryParameter;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Query {
    @XmlAttribute(required=true)
    private String name;
    @XmlElement
    private String description;
    @XmlAttribute(required=true)
    private String content;
    @XmlAttribute(required=true)
    private String returnType;
    @XmlElementWrapper(name="queryParameters")
    @XmlElement(name="queryParameter")
    private List<QueryParameter> queryParameters = new ArrayList<QueryParameter>();

    public Query() {
    }

    public Query(String name, String content, String returnType) {
        this(name, null, content, returnType);
    }

    public Query(String name, String description, String content, String returnType) {
        this();
        this.name = name;
        this.description = description;
        this.content = content;
        this.returnType = returnType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public QueryParameter addQueryParameter(String name, String className) {
        QueryParameter parameter = new QueryParameter(name, className);
        this.queryParameters.add(parameter);
        return parameter;
    }

    public List<QueryParameter> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(List<QueryParameter> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public boolean hasMultipleResults() {
        return List.class.getName().equals(this.returnType);
    }

    public boolean isCountQuery() {
        return Long.class.getName().equals(this.returnType);
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        return Objects.equals(this.name, query.name) && Objects.equals(this.description, query.description) && Objects.equals(this.content, query.content) && Objects.equals(this.returnType, query.returnType) && Objects.equals(this.queryParameters, query.queryParameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.content, this.returnType, this.queryParameters);
    }

    public String toString() {
        return new StringJoiner(", ", Query.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("content='" + this.content + "'").add("returnType='" + this.returnType + "'").add("queryParameters=" + String.valueOf(this.queryParameters)).toString();
    }
}

