/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.model.field;

import java.util.Objects;
import java.util.StringJoiner;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlType;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.field.Field;

@XmlType
public class RelationField
extends Field {
    @XmlAttribute(required=true)
    private Type type;
    @XmlIDREF
    @XmlAttribute(required=true)
    private BusinessObject reference;
    @XmlAttribute(required=true)
    private FetchType fetchType = FetchType.EAGER;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public BusinessObject getReference() {
        return this.reference;
    }

    public void setReference(BusinessObject reference) {
        this.reference = reference;
    }

    public FetchType getFetchType() {
        return this.fetchType;
    }

    public void setFetchType(FetchType fetchType) {
        this.fetchType = fetchType;
    }

    public boolean isLazy() {
        return this.fetchType == FetchType.LAZY;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.type, this.reference == null ? null : this.reference.getQualifiedName()});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RelationField that = (RelationField)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.reference == null ^ that.reference == null) {
            return false;
        }
        if (this.reference != null) {
            return Objects.equals(this.reference.getQualifiedName(), that.reference.getQualifiedName());
        }
        return true;
    }

    public String toString() {
        return new StringJoiner(", ", RelationField.class.getSimpleName() + "[", "]").add("name=" + this.getName()).add("type=" + String.valueOf((Object)this.type)).add("reference=" + String.valueOf(this.reference)).toString();
    }

    @XmlType(namespace="http://documentation.bonitasoft.com/bdm-xml-schema/1.0")
    public static enum FetchType {
        EAGER,
        LAZY;

    }

    @XmlType(namespace="http://documentation.bonitasoft.com/bdm-xml-schema/1.0")
    public static enum Type {
        AGGREGATION,
        COMPOSITION;

    }
}

