/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import org.glassfish.hk2.osgiresourcelocator.ResourceFinder;

public class SQLNameValidator {
    private static final int DEFAULT_MAX_LENGTH = 255;
    private static final String SQL_KEYWORDS_RESOURCE = "/blocked_db_keywords";
    private final int maxLength;

    public SQLNameValidator() {
        this(255);
    }

    public SQLNameValidator(int maxLength) {
        this.maxLength = maxLength;
    }

    public boolean isValid(String name) {
        return name.matches("[a-zA-Z][\\d\\w#@]{0," + this.maxLength + "}$") && !this.isSQLKeyword(name);
    }

    public boolean isSQLKeyword(String name) {
        return KeywordsHolder.blockedDbKeywords.contains(name.toUpperCase());
    }

    public List<Grammar> isKeywordDiscouragedBy(String name) {
        return Collections.unmodifiableList(KeywordsHolder.discouragedKeywords.getOrDefault(name.toUpperCase(), Collections.emptyList()));
    }

    private static class KeywordsHolder {
        static Set<String> blockedDbKeywords;
        static Map<String, List<Grammar>> discouragedKeywords;

        private KeywordsHolder() {
        }

        private static InputStream getKeywordsResource(String resourceName) throws IOException {
            URL sqlKeywordsResource = Optional.ofNullable(ResourceFinder.findEntry((String)resourceName)).orElseGet(() -> SQLNameValidator.class.getResource(resourceName));
            if (sqlKeywordsResource == null) {
                throw new FileNotFoundException("SQL Keywords resource not found: " + resourceName);
            }
            return sqlKeywordsResource.openStream();
        }

        static {
            Grammar[] grammars;
            blockedDbKeywords = new HashSet<String>();
            discouragedKeywords = new HashMap<String, List<Grammar>>();
            try (Scanner scanner = new Scanner(KeywordsHolder.getKeywordsResource(SQLNameValidator.SQL_KEYWORDS_RESOURCE));){
                while (scanner.hasNext()) {
                    String word = scanner.nextLine();
                    blockedDbKeywords.add(word.trim());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (Grammar gram : grammars = Grammar.values()) {
                String fileName = "/" + gram.name().toLowerCase() + "_permissive_keywords";
                try (Scanner scanner = new Scanner(KeywordsHolder.getKeywordsResource(fileName));){
                    while (scanner.hasNext()) {
                        String word = scanner.nextLine();
                        discouragedKeywords.putIfAbsent(word, new ArrayList(grammars.length));
                        discouragedKeywords.get(word).add(gram);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static enum Grammar {
        SQL,
        H2,
        POSTGRES,
        ORACLE,
        MYSQL,
        SQLSERVER;


        public String toString() {
            switch (this) {
                case SQL: {
                    return "SQL grammar";
                }
                case H2: {
                    return "H2";
                }
                case POSTGRES: {
                    return "PostgreSQL";
                }
                case ORACLE: {
                    return "Oracle";
                }
                case MYSQL: {
                    return "MySQL";
                }
                case SQLSERVER: {
                    return "Microsoft SQL Server";
                }
            }
            return this.name();
        }
    }
}

