/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.commons.exceptions;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.bonitasoft.engine.commons.exceptions.ExceptionContext;
import org.bonitasoft.engine.commons.exceptions.SExceptionContext;
import org.bonitasoft.engine.commons.exceptions.ScopedException;

public abstract class SBonitaException
extends Exception
implements ExceptionContext,
ScopedException {
    private static final long serialVersionUID = -500856379312027085L;
    private final String exceptionId;
    private final Object[] arguments;
    private String scope = "UNKNOWN";
    private final Map<SExceptionContext, Serializable> context = new TreeMap<SExceptionContext, Serializable>();

    protected SBonitaException() {
        this((Object[])null);
    }

    protected SBonitaException(Object ... arguments) {
        this.exceptionId = this.getClass().getName();
        this.arguments = arguments;
    }

    protected SBonitaException(String message) {
        super(message);
        this.exceptionId = this.getClass().getName();
        this.arguments = null;
    }

    protected SBonitaException(String message, String scope) {
        super(message);
        this.scope = scope;
        this.exceptionId = this.getClass().getName();
        this.arguments = null;
    }

    protected SBonitaException(String message, Throwable cause) {
        super(message, cause);
        ScopedException e;
        this.exceptionId = this.getClass().getName();
        this.arguments = null;
        if (cause instanceof SBonitaException && ((SBonitaException)(e = (SBonitaException)cause)).getContext() != null) {
            this.context.putAll(((SBonitaException)e).getContext());
        }
        if (cause instanceof ScopedException) {
            e = (ScopedException)((Object)cause);
            this.scope = e.getScope();
        }
    }

    protected SBonitaException(String message, String scope, Throwable cause) {
        super(message, cause);
        SBonitaException e;
        this.exceptionId = this.getClass().getName();
        this.arguments = null;
        this.scope = scope;
        if (cause instanceof SBonitaException && (e = (SBonitaException)cause).getContext() != null) {
            this.context.putAll(e.getContext());
        }
    }

    protected SBonitaException(Throwable cause) {
        this(cause, (Object[])null);
        if (cause instanceof ScopedException) {
            ScopedException e = (ScopedException)((Object)cause);
            this.scope = e.getScope();
        }
    }

    protected SBonitaException(Throwable cause, Object ... arguments) {
        super(cause);
        ScopedException e;
        this.exceptionId = this.getClass().getName();
        this.arguments = arguments;
        if (cause instanceof SBonitaException && ((SBonitaException)(e = (SBonitaException)cause)).getContext() != null) {
            this.context.putAll(((SBonitaException)e).getContext());
        }
        if (cause instanceof ScopedException) {
            e = (ScopedException)((Object)cause);
            this.scope = e.getScope();
        }
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getExceptionId() {
        return this.exceptionId;
    }

    public Object[] getParameters() {
        return this.arguments;
    }

    @Override
    public Map<SExceptionContext, Serializable> getContext() {
        return this.context;
    }

    @Override
    public void setProcessDefinitionIdOnContext(long id) {
        this.context.put(SExceptionContext.PROCESS_DEFINITION_ID, Long.valueOf(id));
    }

    @Override
    public void setProcessDefinitionNameOnContext(String name) {
        this.context.put(SExceptionContext.PROCESS_NAME, (Serializable)((Object)name));
    }

    @Override
    public void setProcessDefinitionVersionOnContext(String version) {
        this.context.put(SExceptionContext.PROCESS_VERSION, (Serializable)((Object)version));
    }

    @Override
    public void setProcessInstanceIdOnContext(long id) {
        this.context.put(SExceptionContext.PROCESS_INSTANCE_ID, Long.valueOf(id));
    }

    @Override
    public void setRootProcessInstanceIdOnContext(long id) {
        this.context.put(SExceptionContext.ROOT_PROCESS_INSTANCE_ID, Long.valueOf(id));
    }

    @Override
    public void setConnectorDefinitionIdOnContext(String id) {
        this.context.put(SExceptionContext.CONNECTOR_DEFINITION_ID, (Serializable)((Object)id));
    }

    @Override
    public void setConnectorImplementationClassNameOnContext(String name) {
        this.context.put(SExceptionContext.CONNECTOR_IMPLEMENTATION_CLASS_NAME, (Serializable)((Object)name));
    }

    @Override
    public void setConnectorDefinitionVersionOnContext(String version) {
        this.context.put(SExceptionContext.CONNECTOR_DEFINITION_VERSION, (Serializable)((Object)version));
    }

    @Override
    public void setConnectorActivationEventOnContext(String activationEvent) {
        this.context.put(SExceptionContext.CONNECTOR_ACTIVATION_EVENT, (Serializable)((Object)activationEvent));
    }

    @Override
    public void setConnectorInstanceIdOnContext(long id) {
        this.context.put(SExceptionContext.CONNECTOR_INSTANCE_ID, Long.valueOf(id));
    }

    @Override
    public void setFlowNodeDefinitionIdOnContext(long id) {
        this.context.put(SExceptionContext.FLOW_NODE_DEFINITION_ID, Long.valueOf(id));
    }

    @Override
    public void setFlowNodeInstanceIdOnContext(long id) {
        this.context.put(SExceptionContext.FLOW_NODE_INSTANCE_ID, Long.valueOf(id));
    }

    @Override
    public void setFlowNodeNameOnContext(String name) {
        this.context.put(SExceptionContext.FLOW_NODE_NAME, (Serializable)((Object)name));
    }

    @Override
    public void setMessageInstanceNameOnContext(String name) {
        this.context.put(SExceptionContext.MESSAGE_INSTANCE_NAME, (Serializable)((Object)name));
    }

    @Override
    public void setMessageInstanceTargetProcessOnContext(String name) {
        this.context.put(SExceptionContext.MESSAGE_INSTANCE_TARGET_PROCESS_NAME, (Serializable)((Object)name));
    }

    @Override
    public void setMessageInstanceTargetFlowNodeOnContext(String name) {
        this.context.put(SExceptionContext.MESSAGE_INSTANCE_TARGET_FLOW_NODE_NAME, (Serializable)((Object)name));
    }

    @Override
    public void setWaitingMessageEventTypeOnContext(String eventType) {
        this.context.put(SExceptionContext.WAITING_MESSAGE_INSTANCE_TYPE, (Serializable)((Object)eventType));
    }

    @Override
    public void setDocumentIdOnContext(long id) {
        this.context.put(SExceptionContext.DOCUMENT_ID, Long.valueOf(id));
    }

    @Override
    public void setUserIdOnContext(long userId) {
        this.context.put(SExceptionContext.USER_ID, Long.valueOf(userId));
    }

    @Override
    public void setGroupIdOnContext(long groupId) {
        this.context.put(SExceptionContext.GROUP_ID, Long.valueOf(groupId));
    }

    @Override
    public void setRoleIdOnContext(long roleId) {
        this.context.put(SExceptionContext.ROLE_ID, Long.valueOf(roleId));
    }

    @Override
    public void setConnectorInputOnContext(String inputName) {
        this.context.put(SExceptionContext.CONNECTOR_INPUT_NAME, (Serializable)((Object)inputName));
    }

    @Override
    public void setConnectorNameOnContext(String name) {
        this.context.put(SExceptionContext.CONNECTOR_NAME, (Serializable)((Object)name));
    }

    @Override
    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendContextMessage(stringBuilder);
        this.appendCauseMessage(stringBuilder);
        return stringBuilder.toString();
    }

    private void appendCauseMessage(StringBuilder stringBuilder) {
        String message = super.getMessage();
        if (message != null && message.isEmpty() && this.getCause() != null) {
            message = this.getCause().getMessage();
        }
        if (message != null && !message.trim().isEmpty()) {
            stringBuilder.append(message);
        }
    }

    private void appendContextMessage(StringBuilder stringBuilder) {
        if (this.context != null && !this.context.isEmpty()) {
            for (Map.Entry<SExceptionContext, Serializable> entry : this.context.entrySet()) {
                stringBuilder.append((Object)entry.getKey()).append("=").append(entry.getValue()).append(" | ");
            }
        }
    }
}

