/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.commons.exceptions;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.bonitasoft.engine.commons.exceptions.ExceptionContext;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.exceptions.SExceptionContext;
import org.bonitasoft.engine.commons.exceptions.ScopedException;

public class SBonitaRuntimeException
extends RuntimeException
implements ExceptionContext,
ScopedException {
    private static final long serialVersionUID = 7268935639620676043L;
    private final Map<SExceptionContext, Serializable> context = new TreeMap<SExceptionContext, Serializable>();
    private String scope = "UNKNOWN";

    public SBonitaRuntimeException(Throwable cause) {
        super(cause);
        ScopedException e;
        if (cause instanceof SBonitaException && ((SBonitaException)(e = (SBonitaException)cause)).getContext() != null) {
            this.context.putAll(((SBonitaException)e).getContext());
        }
        if (cause instanceof ScopedException) {
            e = (ScopedException)((Object)cause);
            this.scope = e.getScope();
        }
    }

    public SBonitaRuntimeException(String message, Throwable cause) {
        super(message, cause);
        ScopedException e;
        if (cause instanceof SBonitaException && ((SBonitaException)(e = (SBonitaException)cause)).getContext() != null) {
            this.context.putAll(((SBonitaException)e).getContext());
        }
        if (cause instanceof ScopedException) {
            e = (ScopedException)((Object)cause);
            this.scope = e.getScope();
        }
    }

    public SBonitaRuntimeException(String message, String scope, Throwable cause) {
        super(message, cause);
        SBonitaException e;
        this.scope = scope;
        if (cause instanceof SBonitaException && (e = (SBonitaException)cause).getContext() != null) {
            this.context.putAll(e.getContext());
        }
    }

    public SBonitaRuntimeException(String message) {
        super(message);
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public Map<SExceptionContext, Serializable> getContext() {
        return this.context;
    }

    @Override
    public void setProcessDefinitionIdOnContext(long id) {
        this.context.put(SExceptionContext.PROCESS_DEFINITION_ID, Long.valueOf(id));
    }

    @Override
    public void setProcessDefinitionNameOnContext(String name) {
        this.context.put(SExceptionContext.PROCESS_NAME, (Serializable)((Object)name));
    }

    @Override
    public void setProcessDefinitionVersionOnContext(String version) {
        this.context.put(SExceptionContext.PROCESS_VERSION, (Serializable)((Object)version));
    }

    @Override
    public void setProcessInstanceIdOnContext(long id) {
        this.context.put(SExceptionContext.PROCESS_INSTANCE_ID, Long.valueOf(id));
    }

    @Override
    public void setRootProcessInstanceIdOnContext(long id) {
        this.context.put(SExceptionContext.ROOT_PROCESS_INSTANCE_ID, Long.valueOf(id));
    }

    @Override
    public void setConnectorDefinitionIdOnContext(String id) {
        this.context.put(SExceptionContext.CONNECTOR_DEFINITION_ID, (Serializable)((Object)id));
    }

    @Override
    public void setConnectorImplementationClassNameOnContext(String name) {
        this.context.put(SExceptionContext.CONNECTOR_IMPLEMENTATION_CLASS_NAME, (Serializable)((Object)name));
    }

    @Override
    public void setConnectorDefinitionVersionOnContext(String version) {
        this.context.put(SExceptionContext.CONNECTOR_DEFINITION_VERSION, (Serializable)((Object)version));
    }

    @Override
    public void setConnectorActivationEventOnContext(String activationEvent) {
        this.context.put(SExceptionContext.CONNECTOR_ACTIVATION_EVENT, (Serializable)((Object)activationEvent));
    }

    @Override
    public void setConnectorInstanceIdOnContext(long id) {
        this.context.put(SExceptionContext.CONNECTOR_INSTANCE_ID, Long.valueOf(id));
    }

    @Override
    public void setFlowNodeDefinitionIdOnContext(long id) {
        this.context.put(SExceptionContext.FLOW_NODE_DEFINITION_ID, Long.valueOf(id));
    }

    @Override
    public void setFlowNodeInstanceIdOnContext(long id) {
        this.context.put(SExceptionContext.FLOW_NODE_INSTANCE_ID, Long.valueOf(id));
    }

    @Override
    public void setFlowNodeNameOnContext(String name) {
        this.context.put(SExceptionContext.FLOW_NODE_NAME, (Serializable)((Object)name));
    }

    @Override
    public void setMessageInstanceNameOnContext(String name) {
        this.context.put(SExceptionContext.MESSAGE_INSTANCE_NAME, (Serializable)((Object)name));
    }

    @Override
    public void setMessageInstanceTargetProcessOnContext(String name) {
        this.context.put(SExceptionContext.MESSAGE_INSTANCE_TARGET_PROCESS_NAME, (Serializable)((Object)name));
    }

    @Override
    public void setMessageInstanceTargetFlowNodeOnContext(String name) {
        this.context.put(SExceptionContext.MESSAGE_INSTANCE_TARGET_FLOW_NODE_NAME, (Serializable)((Object)name));
    }

    @Override
    public void setWaitingMessageEventTypeOnContext(String eventType) {
        this.context.put(SExceptionContext.WAITING_MESSAGE_INSTANCE_TYPE, (Serializable)((Object)eventType));
    }

    @Override
    public void setDocumentIdOnContext(long id) {
        this.context.put(SExceptionContext.DOCUMENT_ID, Long.valueOf(id));
    }

    @Override
    public void setUserIdOnContext(long userId) {
        this.context.put(SExceptionContext.USER_ID, Long.valueOf(userId));
    }

    @Override
    public void setGroupIdOnContext(long groupId) {
        this.context.put(SExceptionContext.GROUP_ID, Long.valueOf(groupId));
    }

    @Override
    public void setRoleIdOnContext(long roleId) {
        this.context.put(SExceptionContext.ROLE_ID, Long.valueOf(roleId));
    }

    @Override
    public void setConnectorInputOnContext(String inputName) {
        this.context.put(SExceptionContext.CONNECTOR_INPUT_NAME, (Serializable)((Object)inputName));
    }

    @Override
    public void setConnectorNameOnContext(String name) {
        this.context.put(SExceptionContext.CONNECTOR_NAME, (Serializable)((Object)name));
    }

    @Override
    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendContextMessage(stringBuilder);
        this.appendCauseMessage(stringBuilder);
        return stringBuilder.toString();
    }

    private void appendCauseMessage(StringBuilder stringBuilder) {
        String message = super.getMessage();
        if (message != null && message.isEmpty() && this.getCause() != null) {
            message = this.getCause().getMessage();
        }
        if (message != null && !message.trim().isEmpty()) {
            stringBuilder.append(message);
        }
    }

    private void appendContextMessage(StringBuilder stringBuilder) {
        if (!this.context.isEmpty()) {
            for (Map.Entry<SExceptionContext, Serializable> entry : this.context.entrySet()) {
                stringBuilder.append((Object)entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append(entry.getValue());
                stringBuilder.append(" | ");
            }
        }
    }
}

