/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.data.instance.model.impl;

import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class OffsetDateTimeXStreamConverter
extends AbstractSingleValueConverter {
    public boolean canConvert(Class type) {
        return OffsetDateTime.class.equals((Object)type);
    }

    public String toString(Object source) {
        return source == null ? null : ((OffsetDateTime)source).withOffsetSameInstant(ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public Object fromString(String str) {
        try {
            return OffsetDateTime.parse(str).withOffsetSameInstant(ZoneOffset.UTC);
        }
        catch (DateTimeParseException e) {
            throw new RuntimeException("OffsetDateTime failed to parse the incoming string", e);
        }
    }
}

