/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.data.instance.model.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.util.Map;
import java.util.WeakHashMap;
import org.bonitasoft.engine.data.instance.model.impl.OffsetDateTimeXStreamConverter;

public class XStreamFactory {
    private static final Map<ClassLoader, XStream> XSTREAM_MAP = new WeakHashMap<ClassLoader, XStream>();

    public static XStream getXStream() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return XSTREAM_MAP.computeIfAbsent(classLoader, cl -> {
            XStream xStream = new XStream();
            xStream.ignoreUnknownElements();
            xStream.addPermission(AnyTypePermission.ANY);
            xStream.registerConverter((SingleValueConverter)new OffsetDateTimeXStreamConverter());
            return xStream;
        });
    }

    public static void remove(ClassLoader classLoader) {
        XSTREAM_MAP.remove(classLoader);
    }
}

