/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.home;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import org.bonitasoft.engine.home.Folder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderMgr {
    public static final Logger LOGGER = LoggerFactory.getLogger(FolderMgr.class);
    public static final String TEMP_FOLDER_NAME_PREFIX = "bonita_engine_";

    private static Folder getFolder(File baseFolder, String subFolder) throws IOException {
        return new Folder(new Folder(baseFolder), subFolder);
    }

    static Folder getFolder(Folder baseFolder, String subFolder) throws IOException {
        return new Folder(baseFolder, subFolder);
    }

    static Folder getTempFolder() throws IOException {
        File systemTempFolder = new File(System.getProperty("java.io.tmpdir"));
        Folder tempFolder = FolderMgr.getFolder(systemTempFolder, TEMP_FOLDER_NAME_PREFIX + FolderMgr.getJvmName());
        if (!tempFolder.exists()) {
            FolderMgr.warnIfSomeTempFolderAlreadyExists(systemTempFolder);
            tempFolder.createAsTemporaryFolder();
        }
        return tempFolder;
    }

    private static void warnIfSomeTempFolderAlreadyExists(File systemTempFolder) {
        File[] files = systemTempFolder.listFiles((dir, name) -> dir.isDirectory() && name.startsWith(TEMP_FOLDER_NAME_PREFIX));
        List<File> temporaryFolders = Arrays.asList(files != null ? files : new File[]{});
        if (!temporaryFolders.isEmpty()) {
            LOGGER.warn("The following temporary folders were not deleted on the previous shutdown. This can happen when your JVM crashed or if you did not properly stop the platform.");
            LOGGER.warn("Delete these folders to free up space:");
            for (File temporaryFolder : temporaryFolders) {
                LOGGER.warn(temporaryFolder.getAbsolutePath());
            }
        }
    }

    static Folder getPlatformTempFolder() throws IOException {
        return FolderMgr.getFolder(FolderMgr.getTempFolder(), "platform").createIfNotExists();
    }

    public static Folder getLicensesFolder() throws IOException {
        return FolderMgr.getFolder(FolderMgr.getTempFolder(), "licenses");
    }

    private static Folder getPlatformClassLoaderFolder() throws IOException {
        return FolderMgr.getFolder(FolderMgr.getPlatformTempFolder(), "classloaders").createIfNotExists();
    }

    private static String getJvmName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    static Folder getPlatformGlobalClassLoaderFolder() throws IOException {
        Folder globalFolder = FolderMgr.getFolder(FolderMgr.getPlatformClassLoaderFolder(), "global");
        globalFolder.createIfNotExists();
        return globalFolder;
    }

    private static Folder getPlatformLocalClassLoaderFolder() throws IOException {
        Folder localFolder = FolderMgr.getFolder(FolderMgr.getPlatformClassLoaderFolder(), "local");
        localFolder.createIfNotExists();
        return localFolder;
    }

    static Folder getPlatformLocalClassLoaderFolder(String artifactType) throws IOException {
        Folder localFolder = FolderMgr.getPlatformLocalClassLoaderFolder();
        Folder artifactTypeFolder = FolderMgr.getFolder(localFolder, artifactType);
        artifactTypeFolder.createIfNotExists();
        return artifactTypeFolder;
    }

    static Folder getPlatformLocalClassLoaderFolder(String artifactType, long artifactId) throws IOException {
        Folder artifactTypeFolder = FolderMgr.getPlatformLocalClassLoaderFolder(artifactType);
        Folder artifactIdFolder = FolderMgr.getFolder(artifactTypeFolder, Long.toString(artifactId));
        artifactIdFolder.createIfNotExists();
        return artifactIdFolder;
    }
}

