/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.mdc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bonitasoft.engine.mdc.MDCConstants;
import org.slf4j.MDC;

public abstract class AbstractMDC
implements AutoCloseable,
MDCConstants {
    private Map<String, String> entriesToRestore;

    public AbstractMDC(Map<String, String> contextValues) {
        if (contextValues != null) {
            Map oldMap = Optional.ofNullable(MDC.getCopyOfContextMap()).orElseGet(Collections::emptyMap);
            this.entriesToRestore = new HashMap<String, String>(contextValues.size());
            contextValues.forEach((k, newValue) -> {
                String valueToRestore = oldMap.getOrDefault(k, null);
                this.entriesToRestore.put((String)k, valueToRestore);
            });
            contextValues.forEach((key, value) -> {
                if (value != null) {
                    MDC.put((String)key, (String)value);
                }
            });
        } else {
            this.entriesToRestore = Collections.emptyMap();
        }
    }

    @Override
    public void close() {
        this.entriesToRestore.forEach((k, v) -> {
            if (v == null) {
                MDC.remove((String)k);
            } else {
                MDC.put((String)k, (String)v);
            }
        });
    }
}

