/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.properties;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BonitaConfigProperty {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BonitaConfigProperty.class);
    protected final String propertyKey;
    protected final String displayName;
    private static final Set<String> alreadyLoggedProperties = ConcurrentHashMap.newKeySet();

    public BonitaConfigProperty(String displayName, String propertyKey) {
        this.displayName = displayName;
        this.propertyKey = propertyKey;
    }

    protected void logInitializationMessagesIfFirstTime() {
        if (alreadyLoggedProperties.add(this.propertyKey)) {
            log.info(this.getInitializationMessage());
        }
    }

    abstract String getInitializationMessage();

    protected String envPropertyKey() {
        return this.propertyKey.toUpperCase().replace(".", "_").replaceAll("-", "");
    }

    protected String getProperty(String defaultValue) {
        return System.getProperty(this.propertyKey, System.getenv().getOrDefault(this.envPropertyKey(), defaultValue));
    }

    static void clearLoggedProperties() {
        alreadyLoggedProperties.clear();
    }
}

