/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.properties;

import java.lang.reflect.Field;
import lombok.Generated;
import org.bonitasoft.engine.properties.BonitaProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class BonitaPropertyAnnotationProcessor
implements BeanPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BonitaPropertyAnnotationProcessor.class);
    @Autowired
    private Environment environment;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        for (Field field : bean.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(BonitaProperty.class)) continue;
            BonitaProperty bonitaProperty = field.getAnnotation(BonitaProperty.class);
            String propertyName = bonitaProperty.value();
            if (propertyName.isEmpty()) {
                propertyName = bonitaProperty.name();
            }
            if (propertyName.isEmpty()) {
                throw new InvalidPropertyException(bean.getClass(), "unset property name", "@BonitaProperty 'name' or 'value' attribute is mandatory");
            }
            String[] deprecated = bonitaProperty.deprecated();
            String resolvedValue = null;
            for (String deprecatedPropertyName : deprecated) {
                resolvedValue = this.environment.getProperty(deprecatedPropertyName);
                if (resolvedValue == null) continue;
                log.warn("Warning: property '{}' is deprecated. Please use '{}' instead", (Object)deprecatedPropertyName, (Object)propertyName);
                break;
            }
            if (resolvedValue == null) {
                resolvedValue = this.environment.getProperty(propertyName);
            }
            field.setAccessible(true);
            try {
                field.set(bean, resolvedValue);
            }
            catch (IllegalAccessException e) {
                throw new BeanInitializationException("Failed to set BonitaProperty-annotated field value for bean " + beanName, (Throwable)e);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

