/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.business.application.impl;

import java.util.Objects;
import java.util.StringJoiner;
import org.bonitasoft.engine.business.application.Application;
import org.bonitasoft.engine.business.application.impl.AbstractApplicationImpl;

public class ApplicationImpl
extends AbstractApplicationImpl
implements Application {
    private static final long serialVersionUID = -5393587887795907117L;
    private Long layoutId;
    private Long homePageId;
    private Long themeId;

    public ApplicationImpl(String token, String version, String description) {
        super(token, version, description);
    }

    public ApplicationImpl(String token, String version, String description, Long layoutId, Long themeId) {
        this(token, version, description);
        this.layoutId = layoutId;
        this.themeId = themeId;
    }

    @Override
    public Long getHomePageId() {
        return this.homePageId;
    }

    public void setHomePageId(Long homePageId) {
        this.homePageId = homePageId;
    }

    @Override
    public Long getLayoutId() {
        return this.layoutId;
    }

    @Override
    public Long getThemeId() {
        return this.themeId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApplicationImpl that = (ApplicationImpl)o;
        return this.isEditable() == that.isEditable() && Objects.equals(this.getLayoutId(), that.getLayoutId()) && Objects.equals(this.getHomePageId(), that.getHomePageId()) && Objects.equals(this.getThemeId(), that.getThemeId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getLayoutId(), this.getHomePageId(), this.getThemeId());
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", ApplicationImpl.class.getSimpleName() + "[", "]").add("version='" + this.getVersion() + "'").add("layoutId=" + this.layoutId).add("iconPath='" + this.getIconPath() + "'").add("creationDate=" + String.valueOf(this.getCreationDate())).add("createdBy=" + this.getCreatedBy()).add("lastUpdateDate=" + String.valueOf(this.getLastUpdateDate())).add("updatedBy=" + this.getUpdatedBy()).add("state='" + this.getState() + "'").add("homePageId=" + this.homePageId).add("displayName='" + this.getDisplayName() + "'").add("profileId=" + this.getProfileId()).add("themeId=" + this.themeId).add("description='" + this.getDescription() + "'").add("token='" + this.getToken() + "'").add("hasIcon=" + this.hasIcon()).add("editable=" + this.isEditable()).add("visibility=" + String.valueOf((Object)this.getVisibility())).toString();
    }
}

