(function () {
  try {
    return angular.module('bonitasoft.ui.widgets');
  } catch(e) {
    return angular.module('bonitasoft.ui.widgets', []);
  }
})().directive('customHeaderAlertV2', function() {
    return {
      controllerAs: 'ctrl',
      controller: /**
 * The controller is a JavaScript function that augments the AngularJS scope and exposes functions that can be used in the custom widget template
 * 
 * Custom widget properties defined on the right can be used as variables in a controller with $scope.properties
 * To use AngularJS standard services, you must declare them in the main function arguments.
 * 
 * You can leave the controller empty if you do not need it.
 */
function ($scope) {
    const localStorageKey = $scope.properties.localStoragePropertyName;
    var isClosed = false;
    $scope.preferences = {};
    $scope.preferences.noShowAlert = false;
    
    $scope.hideAskAgainCheckbox = function(){
        return localStorageKey === undefined || localStorageKey === null || localStorageKey === "";
    };
    
    $scope.isAlertVisible = function() {
        const isActive = $scope.properties.isActive;
        
        if(isActive == undefined) {
            return false;
        }
        
        if(localStorageKey){
            //reset alert for new incoming message
            if(isActive != undefined && isActive == false) {
                localStorage.setItem(localStorageKey, true);
                return false;
            }
            
            if(localStorage.getItem(localStorageKey) == null) {
                localStorage.setItem(localStorageKey, true);
            }
            
            return (localStorage.getItem(localStorageKey)  === "true") && !isClosed;
        }
        return !isClosed;

    };
    
    $scope.hideAlert = function() {
        if($scope.preferences.noShowAlert) {
            localStorage.setItem(localStorageKey, false);
        }
        isClosed = true;
    };
    
    $scope.getAlertIcon = function() {
        const style = $scope.properties.style;
        
        switch (style) {
            case 'success' : return 'glyphicon-ok-sign';
            case 'info' : return 'glyphicon-info-sign';
            case 'warning' : 
            case 'danger' : return 'glyphicon-exclamation-sign';
        }
        
    }

},
      template: '<!-- The custom widget template is defined here\n   - You can use standard HTML tags and AngularJS built-in directives, scope and interpolation system\n   - Custom widget properties defined on the right can be used as variables in a templates with properties.newProperty\n   - Functions exposed in the controller can be used with ctrl.newFunction()\n   - You can use the \'environment\' property injected in the scope when inside the Editor whiteboard. It allows to define a mockup\n     of the Custom Widget to be displayed in the whiteboard only. By default the widget is represented by an auto-generated icon\n     and its name (See the <span> below).\n-->\n <div ng-if="environment" class="alert alert-{{ properties.style }}">{{properties.alertTitle}}\n    <div>\n        <p>{{ properties.alertMessage | uiTranslate }}</p>\n    </div>\n </div>\n\n<div id="header-alert" class="alert alert-{{ properties.style }} bonita-alert mbe-0" ng-if="isAlertVisible()" role="alert">\n    <div class="bonita-alert-title">\n        <button type="button" class="close" aria-label="Close" ng-click="hideAlert()">\n            <span aria-hidden="true">&times;</span>\n        </button>\n        <span><i class="glyphicon {{ getAlertIcon() }}"></i> {{ properties.alertTitle | uiTranslate }} </span>\n    </div>\n    <p>{{ properties.alertMessage | uiTranslate }}</p>\n    \n    <div class="no-show-input-container" ng-hide="hideAskAgainCheckbox()">\n        <input type="checkbox" name="noShowAlert" ng-model="preferences.noShowAlert" class="no-show-input" />\n        <label for="noShow" class="no-show-message">{{"Don\'t show this message again" | uiTranslate}}</label>\n    </div>\n    \n</div>'
    };
  });
