CREATE TABLE configuration (
  content_type VARCHAR(50) NOT NULL,
  resource_name VARCHAR(120) NOT NULL,
  resource_content BYTEA NOT NULL,
  CONSTRAINT pk_configuration PRIMARY KEY (content_type, resource_name)
);
CREATE INDEX idx_configuration ON configuration (content_type);

CREATE TABLE contract_data (
  id INT8 NOT NULL,
  kind VARCHAR(20) NOT NULL,
  scopeId INT8 NOT NULL,
  name VARCHAR(50) NOT NULL,
  val TEXT,
  CONSTRAINT pk_contract_data PRIMARY KEY (id, scopeId),
  CONSTRAINT uk_contract_data_kind_scopeid_name UNIQUE (kind, scopeId, name)
);

CREATE TABLE arch_contract_data (
  id INT8 NOT NULL,
  kind VARCHAR(20) NOT NULL,
  scopeId INT8 NOT NULL,
  name VARCHAR(50) NOT NULL,
  val TEXT,
  archiveDate INT8 NOT NULL,
  sourceObjectId INT8 NOT NULL,
  CONSTRAINT pk_arch_contract_data PRIMARY KEY (id, scopeId),
  CONSTRAINT uk_arch_contract_data_kind_scopeid_name UNIQUE (kind, scopeId, name)
);

CREATE TABLE actor (
  id INT8 NOT NULL,
  scopeId INT8 NOT NULL,
  name VARCHAR(50) NOT NULL,
  displayName VARCHAR(75),
  description TEXT,
  initiator BOOLEAN,
  CONSTRAINT uk_actor_id_scopeid_name UNIQUE (id, scopeId, name),
  CONSTRAINT pk_actor PRIMARY KEY (id)
);

CREATE TABLE actormember (
  id INT8 NOT NULL,
  actorId INT8 NOT NULL,
  userId INT8 NOT NULL,
  groupId INT8 NOT NULL,
  roleId INT8 NOT NULL,
  CONSTRAINT uk_actormember_actorid_userid_groupid_roleid UNIQUE (actorId, userId, groupId, roleId),
  CONSTRAINT pk_actormember PRIMARY KEY (id)
);

ALTER TABLE actormember ADD CONSTRAINT fk_actormember_actorid FOREIGN KEY (actorId) REFERENCES actor(id);

CREATE TABLE category (
  id INT8 NOT NULL,
  name VARCHAR(50) NOT NULL,
  creator INT8,
  description TEXT,
  creationDate INT8 NOT NULL,
  lastUpdateDate INT8 NOT NULL,
  CONSTRAINT pk_category PRIMARY KEY (id),
  CONSTRAINT uk_category_name UNIQUE (name)
);

CREATE TABLE processcategorymapping (
  id INT8 NOT NULL,
  categoryid INT8 NOT NULL,
  processid INT8 NOT NULL,
  CONSTRAINT pk_processcategorymapping PRIMARY KEY (id),
  CONSTRAINT uk_processcategorymapping_categoryid_processid UNIQUE (categoryid, processid)
);
ALTER TABLE processcategorymapping ADD CONSTRAINT fk_processcategorymapping_categoryid FOREIGN KEY (categoryid) REFERENCES category(id) ON DELETE CASCADE;

CREATE TABLE arch_process_comment(
  id INT8 NOT NULL,
  userId INT8,
  processInstanceId INT8 NOT NULL,
  postDate INT8 NOT NULL,
  content VARCHAR(512) NOT NULL,
  archiveDate INT8 NOT NULL,
  sourceObjectId INT8 NOT NULL,
  CONSTRAINT pk_arch_process_comment PRIMARY KEY (id)
);
CREATE INDEX idx1_arch_process_comment on arch_process_comment (sourceobjectid);
CREATE INDEX idx2_arch_process_comment on arch_process_comment (processInstanceId, archivedate);

CREATE TABLE process_comment (
  id INT8 NOT NULL,
  kind VARCHAR(25) NOT NULL,
  userId INT8,
  processInstanceId INT8 NOT NULL,
  postDate INT8 NOT NULL,
  content VARCHAR(512) NOT NULL,
  CONSTRAINT pk_process_comment PRIMARY KEY (id)
);
CREATE INDEX idx1_process_comment on process_comment (processInstanceId);

CREATE TABLE process_content (
  id INT8 NOT NULL,
  content TEXT NOT NULL,
  CONSTRAINT pk_process_content PRIMARY KEY (id)
);

CREATE TABLE process_definition (
  id INT8 NOT NULL,
  processId INT8 NOT NULL,
  name VARCHAR(150) NOT NULL,
  version VARCHAR(50) NOT NULL,
  description VARCHAR(255),
  deploymentDate INT8 NOT NULL,
  deployedBy INT8 NOT NULL,
  activationState VARCHAR(30) NOT NULL,
  configurationState VARCHAR(30) NOT NULL,
  displayName VARCHAR(75),
  displayDescription VARCHAR(255),
  lastUpdateDate INT8,
  categoryId INT8,
  iconPath VARCHAR(255),
  content_id INT8 NOT NULL,
  CONSTRAINT pk_process_definition PRIMARY KEY (id),
  CONSTRAINT uk_process_definition_name_version UNIQUE (name, version)
);
ALTER TABLE process_definition ADD CONSTRAINT fk_process_definition_content_id FOREIGN KEY (content_id) REFERENCES process_content(id);

CREATE TABLE document (
  id INT8 NOT NULL,
  author INT8,
  creationdate INT8 NOT NULL,
  hascontent BOOLEAN NOT NULL,
  filename VARCHAR(255),
  mimetype VARCHAR(255),
  url VARCHAR(1024),
  content BYTEA,
  CONSTRAINT pk_document PRIMARY KEY (id)
);

CREATE TABLE document_mapping (
  id INT8 NOT NULL,
  processinstanceid INT8 NOT NULL,
  documentid INT8 NOT NULL,
  name VARCHAR(50) NOT NULL,
  description TEXT,
  version VARCHAR(50) NOT NULL,
  index_ INT NOT NULL,
  CONSTRAINT pk_document_mapping PRIMARY KEY (id)
);
ALTER TABLE document_mapping ADD CONSTRAINT fk_document_mapping_documentid FOREIGN KEY (documentid) REFERENCES document(id) ON DELETE CASCADE;

CREATE TABLE arch_document_mapping (
  id INT8 NOT NULL,
  sourceObjectId INT8,
  processinstanceid INT8 NOT NULL,
  documentid INT8 NOT NULL,
  name VARCHAR(50) NOT NULL,
  description TEXT,
  version VARCHAR(50) NOT NULL,
  index_ INT NOT NULL,
  archiveDate INT8 NOT NULL,
  CONSTRAINT pk_arch_document_mapping PRIMARY KEY (id)
);
CREATE INDEX idx_a_doc_mp_pr_id ON arch_document_mapping (processinstanceid);
ALTER TABLE arch_document_mapping ADD CONSTRAINT fk_arch_document_mapping_documentid FOREIGN KEY (documentid) REFERENCES document(id) ON DELETE CASCADE;

CREATE TABLE arch_process_instance (
  id INT8 NOT NULL,
  name VARCHAR(75) NOT NULL,
  processDefinitionId INT8 NOT NULL,
  description VARCHAR(255),
  startDate INT8 NOT NULL,
  startedBy INT8 NOT NULL,
  startedBySubstitute INT8 NOT NULL,
  endDate INT8 NOT NULL,
  archiveDate INT8 NOT NULL,
  stateId INT NOT NULL,
  lastUpdate INT8 NOT NULL,
  rootProcessInstanceId INT8,
  callerId INT8,
  sourceObjectId INT8 NOT NULL,
  stringIndex1 VARCHAR(255),
  stringIndex2 VARCHAR(255),
  stringIndex3 VARCHAR(255),
  stringIndex4 VARCHAR(255),
  stringIndex5 VARCHAR(255),
  CONSTRAINT pk_arch_process_instance PRIMARY KEY (id)
);
CREATE INDEX idx1_arch_process_instance ON arch_process_instance (sourceObjectId, rootProcessInstanceId, callerId);
CREATE INDEX idx2_arch_process_instance ON arch_process_instance (processDefinitionId, archiveDate);
CREATE INDEX idx3_arch_process_instance ON arch_process_instance (sourceObjectId, callerId, stateId);

CREATE TABLE arch_flownode_instance (
  id INT8 NOT NULL,
  flownodeDefinitionId INT8 NOT NULL,
  kind VARCHAR(25) NOT NULL,
  sourceObjectId INT8,
  archiveDate INT8 NOT NULL,
  rootContainerId INT8 NOT NULL,
  parentContainerId INT8 NOT NULL,
  name VARCHAR(255) NOT NULL,
  displayName VARCHAR(255),
  displayDescription VARCHAR(255),
  stateId INT NOT NULL,
  stateName VARCHAR(50),
  terminal BOOLEAN NOT NULL,
  stable BOOLEAN ,
  actorId INT8 NULL,
  assigneeId INT8 DEFAULT 0 NOT NULL,
  reachedStateDate INT8,
  lastUpdateDate INT8,
  expectedEndDate INT8,
  claimedDate INT8,
  priority SMALLINT,
  gatewayType VARCHAR(50),
  hitBys VARCHAR(255),
  logicalGroup1 INT8 NOT NULL,
  logicalGroup2 INT8 NOT NULL,
  logicalGroup3 INT8,
  logicalGroup4 INT8 NOT NULL,
  loop_counter INT,
  loop_max INT,
  loopCardinality INT,
  loopDataInputRef VARCHAR(255),
  loopDataOutputRef VARCHAR(255),
  description VARCHAR(255),
  sequential BOOLEAN,
  dataInputItemRef VARCHAR(255),
  dataOutputItemRef VARCHAR(255),
  nbActiveInst INT,
  nbCompletedInst INT,
  nbTerminatedInst INT,
  executedBy INT8,
  executedBySubstitute INT8,
  activityInstanceId INT8,
  aborting BOOLEAN NOT NULL,
  triggeredByEvent BOOLEAN,
  interrupting BOOLEAN,
  CONSTRAINT pk_arch_flownode_instance PRIMARY KEY (id)
);
CREATE INDEX idx_afi_kind_lg2_executedBy ON arch_flownode_instance(logicalGroup2, kind, executedBy);
CREATE INDEX idx_afi_kind_lg3 ON arch_flownode_instance(kind, logicalGroup3);
CREATE INDEX idx_afi_lg4 ON arch_flownode_instance(logicalGroup4);
CREATE INDEX idx_afi_sourceid_kind ON arch_flownode_instance (sourceObjectId, kind);
CREATE INDEX idx1_afi_root_parent ON arch_flownode_instance (rootContainerId, parentContainerId);
CREATE INDEX idx_lg4_lg2 on arch_flownode_instance(logicalGroup4, logicalGroup2);

CREATE TABLE arch_connector_instance (
  id INT8 NOT NULL,
  containerId INT8 NOT NULL,
  containerType VARCHAR(10) NOT NULL,
  connectorId VARCHAR(255) NOT NULL,
  version VARCHAR(50) NOT NULL,
  name VARCHAR(255) NOT NULL,
  activationEvent VARCHAR(30),
  state VARCHAR(50),
  sourceObjectId INT8,
  archiveDate INT8 NOT NULL,
  CONSTRAINT pk_arch_connector_instance PRIMARY KEY (id)
);
CREATE INDEX idx1_arch_connector_instance ON arch_connector_instance (containerId, containerType);

CREATE TABLE process_instance (
  id INT8 NOT NULL,
  name VARCHAR(75) NOT NULL,
  processDefinitionId INT8 NOT NULL,
  description VARCHAR(255),
  startDate INT8 NOT NULL,
  startedBy INT8 NOT NULL,
  startedBySubstitute INT8 NOT NULL,
  endDate INT8 NOT NULL,
  stateId INT NOT NULL,
  stateCategory VARCHAR(50) NOT NULL,
  lastUpdate INT8 NOT NULL,
  containerId INT8,
  rootProcessInstanceId INT8,
  callerId INT8,
  callerType VARCHAR(50),
  interruptingEventId INT8,
  stringIndex1 VARCHAR(255),
  stringIndex2 VARCHAR(255),
  stringIndex3 VARCHAR(255),
  stringIndex4 VARCHAR(255),
  stringIndex5 VARCHAR(255),
  PRIMARY KEY (id)
);

CREATE INDEX idx1_proc_inst_pdef_state ON process_instance (processdefinitionid, stateid);

CREATE TABLE flownode_instance (
  id INT8 NOT NULL,
  flownodeDefinitionId INT8 NOT NULL,
  kind VARCHAR(25) NOT NULL,
  rootContainerId INT8 NOT NULL,
  parentContainerId INT8 NOT NULL,
  name VARCHAR(255) NOT NULL,
  displayName VARCHAR(255),
  displayDescription VARCHAR(255),
  stateId INT NOT NULL,
  stateName VARCHAR(50),
  prev_state_id INT NOT NULL,
  terminal BOOLEAN NOT NULL,
  stable BOOLEAN ,
  actorId INT8 NULL,
  assigneeId INT8 DEFAULT 0 NOT NULL,
  reachedStateDate INT8,
  lastUpdateDate INT8,
  expectedEndDate INT8,
  claimedDate INT8,
  priority SMALLINT,
  gatewayType VARCHAR(50),
  hitBys VARCHAR(255),
  stateCategory VARCHAR(50) NOT NULL,
  logicalGroup1 INT8 NOT NULL,
  logicalGroup2 INT8 NOT NULL,
  logicalGroup3 INT8,
  logicalGroup4 INT8 NOT NULL,
  loop_counter INT,
  loop_max INT,
  description VARCHAR(255),
  sequential BOOLEAN,
  loopDataInputRef VARCHAR(255),
  loopDataOutputRef VARCHAR(255),
  dataInputItemRef VARCHAR(255),
  dataOutputItemRef VARCHAR(255),
  loopCardinality INT,
  nbActiveInst INT,
  nbCompletedInst INT,
  nbTerminatedInst INT,
  executedBy INT8,
  executedBySubstitute INT8,
  activityInstanceId INT8,
  state_executing BOOLEAN DEFAULT FALSE,
  abortedByBoundary INT8,
  triggeredByEvent BOOLEAN,
  interrupting BOOLEAN,
  tokenCount INT NOT NULL,
  PRIMARY KEY (id)
);
CREATE INDEX idx_fni_rootcontid ON flownode_instance (rootContainerId);
CREATE INDEX idx_fni_loggroup4 ON flownode_instance (logicalGroup4);
CREATE INDEX idx_fni_loggroup3_terminal ON flownode_instance(logicalgroup3, terminal);
CREATE INDEX idx_fn_lg2_state ON flownode_instance (logicalGroup2, stateName);
CREATE INDEX idx_fni_activity_instance_id_kind ON flownode_instance(activityInstanceId, kind);

CREATE TABLE connector_instance (
  id INT8 NOT NULL,
  containerId INT8 NOT NULL,
  containerType VARCHAR(10) NOT NULL,
  connectorId VARCHAR(255) NOT NULL,
  version VARCHAR(50) NOT NULL,
  name VARCHAR(255) NOT NULL,
  activationEvent VARCHAR(30),
  state VARCHAR(50),
  executionOrder INT,
  exceptionMessage VARCHAR(255),
  stackTrace TEXT,
  CONSTRAINT pk_connector_instance PRIMARY KEY (id)
);
CREATE INDEX idx_ci_container_activation ON connector_instance (containerId, containerType, activationEvent);

CREATE TABLE event_trigger_instance (
  	id INT8 NOT NULL,
  	eventInstanceId INT8 NOT NULL,
  	eventInstanceName VARCHAR(50),
  	executionDate INT8,
  	jobTriggerName VARCHAR(255),
    CONSTRAINT pk_event_trigger_instance PRIMARY KEY (id)
);

CREATE TABLE waiting_event (
  	id INT8 NOT NULL,
  	kind VARCHAR(15) NOT NULL,
  	eventType VARCHAR(50),
  	messageName VARCHAR(255),
  	signalName VARCHAR(255),
  	errorCode VARCHAR(255),
  	processName VARCHAR(150),
  	flowNodeName VARCHAR(50),
  	flowNodeDefinitionId INT8,
  	subProcessId INT8,
  	processDefinitionId INT8,
  	rootProcessInstanceId INT8,
  	parentProcessInstanceId INT8,
  	flowNodeInstanceId INT8,
  	relatedActivityInstanceId INT8,
  	locked BOOLEAN,
  	active BOOLEAN,
  	progress SMALLINT,
  	correlation1 VARCHAR(128),
  	correlation2 VARCHAR(128),
  	correlation3 VARCHAR(128),
  	correlation4 VARCHAR(128),
  	correlation5 VARCHAR(128),
    CONSTRAINT pk_waiting_event PRIMARY KEY (id)
);
CREATE INDEX idx_waiting_event ON waiting_event (progress, kind, locked, active);
CREATE INDEX idx_waiting_event_correl ON waiting_event (correlation1, correlation2, correlation3, correlation4, correlation5);

CREATE TABLE message_instance (
  	id INT8 NOT NULL,
  	messageName VARCHAR(255) NOT NULL,
  	targetProcess VARCHAR(255) NOT NULL,
  	targetFlowNode VARCHAR(255) NULL,
  	locked BOOLEAN NOT NULL,
  	handled BOOLEAN NOT NULL,
  	processDefinitionId INT8 NOT NULL,
  	flowNodeName VARCHAR(255),
  	correlation1 VARCHAR(128),
  	correlation2 VARCHAR(128),
  	correlation3 VARCHAR(128),
  	correlation4 VARCHAR(128),
  	correlation5 VARCHAR(128),
  	creationDate INT8 NOT NULL,
    CONSTRAINT pk_message_instance PRIMARY KEY (id)
);
CREATE INDEX idx_message_instance ON message_instance (messageName, targetProcess, correlation1, correlation2, correlation3);
CREATE INDEX idx_message_instance_correl ON message_instance (correlation1, correlation2, correlation3, correlation4, correlation5);

CREATE TABLE pending_mapping (
  	id INT8 NOT NULL,
  	activityId INT8 NOT NULL,
  	actorId INT8,
  	userId INT8,
  	CONSTRAINT pk_pending_mapping PRIMARY KEY (id),
    CONSTRAINT uk_pending_mapping_activityid_userid_actorid UNIQUE (activityId, userId, actorId)
);
ALTER TABLE pending_mapping ADD CONSTRAINT fk_pending_mapping_activityid FOREIGN KEY (activityId) REFERENCES flownode_instance(id);

CREATE TABLE ref_biz_data_inst (
  id INT8 NOT NULL,
  kind VARCHAR(15) NOT NULL,
  name VARCHAR(255) NOT NULL,
  proc_inst_id INT8,
  fn_inst_id INT8,
  data_id INT8,
  data_classname VARCHAR(255) NOT NULL,
  CONSTRAINT pk_ref_biz_data_inst PRIMARY KEY (id)
);
CREATE INDEX idx_biz_data_inst2 ON ref_biz_data_inst (fn_inst_id);
CREATE INDEX idx_biz_data_inst3 ON ref_biz_data_inst (proc_inst_id);
ALTER TABLE ref_biz_data_inst ADD CONSTRAINT fk_ref_biz_data_inst_proc_inst_id FOREIGN KEY (proc_inst_id) REFERENCES process_instance(id) ON DELETE CASCADE;
ALTER TABLE ref_biz_data_inst ADD CONSTRAINT fk_ref_biz_data_inst_fn_inst_id FOREIGN KEY (fn_inst_id) REFERENCES flownode_instance(id) ON DELETE CASCADE;

CREATE TABLE multi_biz_data (
  id INT8 NOT NULL,
  idx INT8 NOT NULL,
  data_id INT8 NOT NULL,
  CONSTRAINT pk_multi_biz_data PRIMARY KEY (id, data_id)
);
ALTER TABLE multi_biz_data ADD CONSTRAINT fk_multi_biz_data_id FOREIGN KEY (id) REFERENCES ref_biz_data_inst(id) ON DELETE CASCADE;

CREATE TABLE arch_ref_biz_data_inst (
  id BIGINT NOT NULL,
  kind VARCHAR(15) NOT NULL,
  name VARCHAR(255) NOT NULL,
  orig_proc_inst_id BIGINT,
  orig_fn_inst_id BIGINT,
  data_id BIGINT,
  data_classname VARCHAR(255) NOT NULL,
  CONSTRAINT pk_arch_ref_biz_data_inst PRIMARY KEY (id)
);
CREATE INDEX idx_arch_biz_data_inst1 ON arch_ref_biz_data_inst (orig_proc_inst_id);
CREATE INDEX idx_arch_biz_data_inst2 ON arch_ref_biz_data_inst (orig_fn_inst_id);

CREATE TABLE arch_multi_biz_data (
  id BIGINT NOT NULL,
  idx BIGINT NOT NULL,
  data_id BIGINT NOT NULL,
  CONSTRAINT pk_arch_multi_biz_data PRIMARY KEY (id, data_id)
);
ALTER TABLE arch_multi_biz_data ADD CONSTRAINT fk_arch_multi_biz_data_id FOREIGN KEY (id) REFERENCES arch_ref_biz_data_inst(id) ON DELETE CASCADE;

CREATE TABLE processsupervisor (
  id INT8 NOT NULL,
  processDefId INT8 NOT NULL,
  userId INT8 NOT NULL,
  groupId INT8 NOT NULL,
  roleId INT8 NOT NULL,
  CONSTRAINT pk_processsupervisor PRIMARY KEY (id),
  CONSTRAINT uk_processsupervisor_processdefid_userid_groupid_roleid UNIQUE (processDefId, userId, groupId, roleId)
);

CREATE TABLE page (
  id INT8 NOT NULL,
  name VARCHAR(255) NOT NULL,
  displayName VARCHAR(255) NOT NULL,
  description TEXT,
  installationDate INT8 NOT NULL,
  installedBy INT8 NOT NULL,
  provided BOOLEAN,
  editable BOOLEAN,
  removable BOOLEAN,
  lastModificationDate INT8 NOT NULL,
  lastUpdatedBy INT8 NOT NULL,
  contentName VARCHAR(280) NOT NULL,
  content BYTEA,
  contentType VARCHAR(50) NOT NULL,
  processDefinitionId INT8 NOT NULL,
  pageHash VARCHAR(32),
  CONSTRAINT pk_page PRIMARY KEY (id),
  CONSTRAINT uk_page_name_processdefinitionid UNIQUE (name, processDefinitionId)
);

CREATE TABLE profile (
  id INT8 NOT NULL,
  isDefault BOOLEAN NOT NULL,
  name VARCHAR(50) NOT NULL,
  description TEXT,
  creationDate INT8 NOT NULL,
  createdBy INT8 NOT NULL,
  lastUpdateDate INT8 NOT NULL,
  lastUpdatedBy INT8 NOT NULL,
  CONSTRAINT uk_profile_name UNIQUE (name),
  CONSTRAINT pk_profile PRIMARY KEY (id)
);

CREATE TABLE profilemember (
  id INT8 NOT NULL,
  profileId INT8 NOT NULL,
  userId INT8 NOT NULL,
  groupId INT8 NOT NULL,
  roleId INT8 NOT NULL,
  CONSTRAINT pk_profilemember PRIMARY KEY (id),
  CONSTRAINT uk_profilemember_profileid_userid_groupid_roleid UNIQUE (profileId, userId, groupId, roleId)
);
ALTER TABLE profilemember ADD CONSTRAINT fk_profilemember_profileid FOREIGN KEY (profileId) REFERENCES profile(id);

CREATE TABLE business_app (
  id INT8 NOT NULL,
  token VARCHAR(50) NOT NULL,
  version VARCHAR(50) NOT NULL,
  description TEXT,
  iconPath VARCHAR(255),
  creationDate INT8 NOT NULL,
  createdBy INT8 NOT NULL,
  lastUpdateDate INT8 NOT NULL,
  updatedBy INT8 NOT NULL,
  state VARCHAR(30) NOT NULL,
  homePageId INT8,
  profileId INT8,
  layoutId INT8,
  themeId INT8,
  iconMimeType VARCHAR(255),
  iconContent BYTEA,
  displayName VARCHAR(255) NOT NULL,
  editable BOOLEAN,
  internalProfile VARCHAR(255),
  isLink BOOLEAN DEFAULT FALSE,
  CONSTRAINT pk_business_app PRIMARY KEY (id),
  CONSTRAINT uk_business_app_token_version UNIQUE (token, version)
);
CREATE INDEX idx_app_token ON business_app (token);
CREATE INDEX idx_app_profile ON business_app (profileId);
CREATE INDEX idx_app_homepage ON business_app (homePageId);
ALTER TABLE business_app ADD CONSTRAINT fk_business_app_profileid FOREIGN KEY (profileId) REFERENCES profile (id);
ALTER TABLE business_app ADD CONSTRAINT fk_business_app_layoutid FOREIGN KEY (layoutId) REFERENCES page (id);
ALTER TABLE business_app ADD CONSTRAINT fk_business_app_themeid FOREIGN KEY (themeId) REFERENCES page (id);

CREATE TABLE business_app_page (
  id INT8 NOT NULL,
  applicationId INT8 NOT NULL,
  pageId INT8 NOT NULL,
  token VARCHAR(255) NOT NULL,
  CONSTRAINT pk_business_app_page PRIMARY KEY (id),
  CONSTRAINT uk_business_app_page_applicationid_token UNIQUE (applicationId, token)
);
CREATE INDEX idx_app_page_token ON business_app_page (applicationId, token);
CREATE INDEX idx_app_page_pageId ON business_app_page (pageId);
ALTER TABLE business_app_page ADD CONSTRAINT fk_business_app_page_applicationid FOREIGN KEY (applicationId) REFERENCES business_app (id) ON DELETE CASCADE;
ALTER TABLE business_app_page ADD CONSTRAINT fk_business_app_page_pageid FOREIGN KEY (pageId) REFERENCES page (id);

CREATE TABLE business_app_menu (
  id INT8 NOT NULL,
  displayName VARCHAR(255) NOT NULL,
  applicationId INT8 NOT NULL,
  applicationPageId INT8,
  parentId INT8,
  index_ INT8,
  CONSTRAINT pk_business_app_menu PRIMARY KEY (id)
);
CREATE INDEX idx_app_menu_app ON business_app_menu (applicationId);
CREATE INDEX idx_app_menu_page ON business_app_menu (applicationPageId);
CREATE INDEX idx_app_menu_parent ON business_app_menu (parentId);
-- cannot have both fk_business_app_menu_applicationid and fk_business_app_menu_applicationpageid because this create to path for deletion of business_app_menu elements:
-- business_app -> business_app_menu
-- business_app -> business_app_page -> business_app_menu
-- this is not allowed in SQL Server
ALTER TABLE business_app_menu ADD CONSTRAINT fk_business_app_menu_applicationid FOREIGN KEY (applicationId) REFERENCES business_app (id);
ALTER TABLE business_app_menu ADD CONSTRAINT fk_business_app_menu_applicationpageid FOREIGN KEY (applicationPageId) REFERENCES business_app_page (id);
ALTER TABLE business_app_menu ADD CONSTRAINT fk_business_app_menu_parentid FOREIGN KEY (parentId) REFERENCES business_app_menu (id);

CREATE TABLE command (
  id INT8 NOT NULL,
  name VARCHAR(50) NOT NULL,
  description TEXT,
  IMPLEMENTATION VARCHAR(100) NOT NULL,
  isSystem BOOLEAN,
  CONSTRAINT pk_command PRIMARY KEY (id),
  CONSTRAINT uk_command_name UNIQUE (name)
);

CREATE TABLE arch_data_instance (
  id INT8 NOT NULL,
  name VARCHAR(50),
  description VARCHAR(50),
  transientData BOOLEAN,
  className VARCHAR(100),
  containerId INT8,
  containerType VARCHAR(60),
  namespace VARCHAR(100),
  element VARCHAR(60),
  intValue INT,
  longValue INT8,
  shortTextValue VARCHAR(255),
  booleanValue BOOLEAN,
  doubleValue NUMERIC(19,5),
  floatValue REAL,
  blobValue BYTEA,
  clobValue TEXT,
  discriminant VARCHAR(50) NOT NULL,
  archiveDate INT8 NOT NULL,
  sourceObjectId INT8 NOT NULL,
  CONSTRAINT pk_arch_data_instance PRIMARY KEY (id)
);
CREATE INDEX idx1_arch_data_instance ON arch_data_instance (containerId, containerType, archiveDate, name, sourceObjectId);
CREATE INDEX idx2_arch_data_instance ON arch_data_instance (sourceObjectId, containerId, archiveDate, id);

CREATE TABLE data_instance (
  id INT8 NOT NULL,
  name VARCHAR(50),
  description VARCHAR(50),
  transientData BOOLEAN,
  className VARCHAR(100),
  containerId INT8,
  containerType VARCHAR(60),
  namespace VARCHAR(100),
  element VARCHAR(60),
  intValue INT,
  longValue INT8,
  shortTextValue VARCHAR(255),
  booleanValue BOOLEAN,
  doubleValue NUMERIC(19,5),
  floatValue REAL,
  blobValue BYTEA,
  clobValue TEXT,
  discriminant VARCHAR(50) NOT NULL,
  CONSTRAINT pk_data_instance PRIMARY KEY (id)
);
CREATE INDEX idx_datai_container ON data_instance (containerId, containerType, name);

CREATE TABLE dependency (
  id INT8 NOT NULL,
  name VARCHAR(150) NOT NULL,
  description TEXT,
  filename VARCHAR(255) NOT NULL,
  value_ BYTEA NOT NULL,
  CONSTRAINT pk_dependency PRIMARY KEY (id),
  CONSTRAINT uk_dependency_name UNIQUE (name)
);

CREATE TABLE dependencymapping (
  id INT8 NOT NULL,
  artifactid INT8 NOT NULL,
  artifacttype VARCHAR(50) NOT NULL,
  dependencyid INT8 NOT NULL,
  CONSTRAINT pk_dependencymapping PRIMARY KEY (id),
  CONSTRAINT uk_dependencymapping_dependencyid_artifactid_artifacttype UNIQUE (dependencyid, artifactid, artifacttype)
);
CREATE INDEX idx_dependencymapping_depid ON dependencymapping (dependencyid);
ALTER TABLE dependencymapping ADD CONSTRAINT fk_dependencymapping_dependencyid FOREIGN KEY (dependencyid) REFERENCES dependency(id) ON DELETE CASCADE;

CREATE TABLE pdependency (
  id INT8 NOT NULL,
  name VARCHAR(50) NOT NULL,
  description TEXT,
  filename VARCHAR(255) NOT NULL,
  value_ BYTEA NOT NULL,
  CONSTRAINT pk_pdependency PRIMARY KEY (id),
  CONSTRAINT uk_pdependency_name UNIQUE (name)
);

CREATE TABLE pdependencymapping (
  id INT8 NOT NULL,
  artifactid INT8 NOT NULL,
  artifacttype VARCHAR(50) NOT NULL,
  dependencyid INT8 NOT NULL,
  CONSTRAINT pk_pdependencymapping PRIMARY KEY (id),
  CONSTRAINT uk_pdependencymapping_dependencyid_artifactid_artifacttype UNIQUE (dependencyid, artifactid, artifacttype)
);
CREATE INDEX idx_pdependencymapping_depid ON pdependencymapping (dependencyid);
ALTER TABLE pdependencymapping ADD CONSTRAINT fk_pdependencymapping_dependencyid FOREIGN KEY (dependencyid) REFERENCES pdependency(id) ON DELETE CASCADE;

CREATE TABLE group_ (
  id INT8 NOT NULL,
  name VARCHAR(125) NOT NULL,
  parentPath VARCHAR(255),
  displayName VARCHAR(255),
  description TEXT,
  createdBy INT8,
  creationDate INT8,
  lastUpdate INT8,
  iconid INT8,
  CONSTRAINT pk_group PRIMARY KEY (id)
);
CREATE INDEX idx_group_name ON group_ (parentPath, name);

CREATE TABLE role (
  id INT8 NOT NULL,
  name VARCHAR(255) NOT NULL,
  displayName VARCHAR(255),
  description TEXT,
  createdBy INT8,
  creationDate INT8,
  lastUpdate INT8,
  iconid INT8,
  CONSTRAINT pk_role PRIMARY KEY (id),
  CONSTRAINT uk_role_name UNIQUE (name)
);

CREATE TABLE user_ (
  id INT8 NOT NULL,
  enabled BOOLEAN NOT NULL,
  userName VARCHAR(255) NOT NULL,
  password VARCHAR(60),
  firstName VARCHAR(255),
  lastName VARCHAR(255),
  title VARCHAR(50),
  jobTitle VARCHAR(255),
  managerUserId INT8,
  createdBy INT8,
  creationDate INT8,
  lastUpdate INT8,
  iconid INT8,
  CONSTRAINT pk_user PRIMARY KEY (id),
  CONSTRAINT uk_user_username UNIQUE (userName)
);

CREATE TABLE user_login (
  id INT8 NOT NULL,
  lastConnection INT8,
  CONSTRAINT pk_user_login PRIMARY KEY (id)
);

CREATE TABLE user_contactinfo (
  id INT8 NOT NULL,
  userId INT8 NOT NULL,
  email VARCHAR(255),
  phone VARCHAR(50),
  mobile VARCHAR(50),
  fax VARCHAR(50),
  building VARCHAR(50),
  room VARCHAR(50),
  address VARCHAR(255),
  zipCode VARCHAR(50),
  city VARCHAR(255),
  state VARCHAR(255),
  country VARCHAR(255),
  website VARCHAR(255),
  personal BOOLEAN NOT NULL,
  CONSTRAINT pk_user_contactinfo PRIMARY KEY (id),
  CONSTRAINT uk_user_contactinfo_userid_personal UNIQUE (userId, personal)
);
ALTER TABLE user_contactinfo ADD CONSTRAINT fk_user_contactinfo_userid FOREIGN KEY (userId) REFERENCES user_ (id) ON DELETE CASCADE;

CREATE TABLE custom_usr_inf_def (
  id INT8 NOT NULL,
  name VARCHAR(75) NOT NULL,
  description TEXT,
  CONSTRAINT pk_custom_usr_inf_def PRIMARY KEY (id),
  CONSTRAINT uk_custom_usr_inf_def_name UNIQUE (name)
);

CREATE TABLE custom_usr_inf_val (
  id INT8 NOT NULL,
  definitionId INT8 NOT NULL,
  userId INT8 NOT NULL,
  value VARCHAR(255),
  CONSTRAINT pk_custom_usr_inf_val PRIMARY KEY (id),
  CONSTRAINT uk_custom_usr_inf_val_definitionid_userid UNIQUE (definitionId, userId)
);
ALTER TABLE custom_usr_inf_val ADD CONSTRAINT fk_custom_usr_inf_val_userid FOREIGN KEY (userId) REFERENCES user_ (id) ON DELETE CASCADE;
ALTER TABLE custom_usr_inf_val ADD CONSTRAINT fk_custom_usr_inf_val_definitionid FOREIGN KEY (definitionId) REFERENCES custom_usr_inf_def (id) ON DELETE CASCADE;

CREATE TABLE user_membership (
  id INT8 NOT NULL,
  userId INT8 NOT NULL,
  roleId INT8 NOT NULL,
  groupId INT8 NOT NULL,
  assignedBy INT8,
  assignedDate INT8,
  CONSTRAINT pk_user_membership PRIMARY KEY (id),
  CONSTRAINT uk_user_membership_userid_roleid_groupid UNIQUE (userId, roleId, groupId)
);

CREATE TABLE icon (
  id INT8 NOT NULL,
  mimetype VARCHAR(255) NOT NULL,
  content BYTEA NOT NULL,
  CONSTRAINT pk_icon PRIMARY KEY (id)
);

CREATE TABLE queriable_log (
  id INT8 NOT NULL,
  log_timestamp INT8 NOT NULL,
  whatYear SMALLINT NOT NULL,
  whatMonth SMALLINT NOT NULL,
  dayOfYear SMALLINT NOT NULL,
  weekOfYear SMALLINT NOT NULL,
  userId VARCHAR(255) NOT NULL,
  threadNumber INT8 NOT NULL,
  clusterNode VARCHAR(50),
  productVersion VARCHAR(50) NOT NULL,
  severity VARCHAR(50) NOT NULL,
  actionType VARCHAR(50) NOT NULL,
  actionScope VARCHAR(100),
  actionStatus SMALLINT NOT NULL,
  rawMessage VARCHAR(255) NOT NULL,
  callerClassName VARCHAR(200),
  callerMethodName VARCHAR(80),
  numericIndex1 INT8,
  numericIndex2 INT8,
  numericIndex3 INT8,
  numericIndex4 INT8,
  numericIndex5 INT8,
  CONSTRAINT pk_queriable_log PRIMARY KEY (id)
);

CREATE TABLE sequence (
  id INT8 NOT NULL,
  nextid INT8 NOT NULL,
  CONSTRAINT pk_sequence PRIMARY KEY (id)
);

CREATE TABLE platform (
  id INT8 NOT NULL,
  version VARCHAR(50) NOT NULL,
  initial_bonita_version VARCHAR(50) NOT NULL,
  application_version VARCHAR(50) NOT NULL,
  maintenance_message TEXT,
  maintenance_message_active BOOLEAN NOT NULL,
  created INT8 NOT NULL,
  created_by VARCHAR(50) NOT NULL,
  information TEXT,
  maintenance_enabled BOOLEAN NOT NULL,
  CONSTRAINT pk_platform PRIMARY KEY (id)
);

CREATE TABLE platformCommand (
  id INT8 PRIMARY KEY,
  name VARCHAR(50) NOT NULL UNIQUE,
  description TEXT,
  IMPLEMENTATION VARCHAR(100) NOT NULL
);

CREATE TABLE job_desc (
  id INT8 NOT NULL,
  jobclassname VARCHAR(100) NOT NULL,
  jobname VARCHAR(100) NOT NULL,
  description VARCHAR(50),
  CONSTRAINT pk_job_desc PRIMARY KEY (id)
);

CREATE TABLE job_param (
  id INT8 NOT NULL,
  jobDescriptorId INT8 NOT NULL,
  key_ VARCHAR(50) NOT NULL,
  value_ BYTEA NOT NULL,
  CONSTRAINT pk_job_param PRIMARY KEY (id)
);
ALTER TABLE job_param ADD CONSTRAINT fk_job_param_jobdescriptorid FOREIGN KEY (jobDescriptorId) REFERENCES job_desc(id) ON DELETE CASCADE;
CREATE INDEX idx_job_param_jobid ON job_param(jobDescriptorId);

CREATE TABLE job_log (
  id INT8 NOT NULL,
  jobDescriptorId INT8 NOT NULL,
  retryNumber INT8,
  lastUpdateDate INT8,
  lastMessage TEXT,
  CONSTRAINT pk_job_log PRIMARY KEY (id),
  CONSTRAINT uk_job_log_jobdescriptorid UNIQUE (jobDescriptorId)
);
ALTER TABLE job_log ADD CONSTRAINT fk_job_log_jobdescriptorid FOREIGN KEY (jobDescriptorId) REFERENCES job_desc(id) ON DELETE CASCADE;

CREATE TABLE page_mapping (
  id INT8 NOT NULL,
  key_ VARCHAR(255) NOT NULL,
  pageId INT8 NULL,
  url VARCHAR(1024) NULL,
  urladapter VARCHAR(255) NULL,
  page_authoriz_rules TEXT NULL,
  lastUpdateDate INT8 NULL,
  lastUpdatedBy INT8 NULL,
  CONSTRAINT uk_page_mapping_key UNIQUE (key_),
  CONSTRAINT pk_page_mapping PRIMARY KEY (id)
);

CREATE TABLE form_mapping (
  id INT8 NOT NULL,
  process INT8 NOT NULL,
  type INT NOT NULL,
  task VARCHAR(255),
  page_mapping_id INT8,
  lastUpdateDate INT8,
  lastUpdatedBy INT8,
  target VARCHAR(16) NOT NULL,
  CONSTRAINT pk_form_mapping PRIMARY KEY (id)
);

ALTER TABLE form_mapping ADD CONSTRAINT fk_form_mapping_key FOREIGN KEY (page_mapping_id) REFERENCES page_mapping(id);

CREATE TABLE proc_parameter (
  id INT8 NOT NULL,
  process_id INT8 NOT NULL,
  name VARCHAR(255) NOT NULL,
  value TEXT NULL,
  CONSTRAINT pk_proc_parameter PRIMARY KEY (id)
);

CREATE TABLE bar_resource (
  id INT8 NOT NULL,
  process_id INT8 NOT NULL,
  name VARCHAR(255) NOT NULL,
  type VARCHAR(16) NOT NULL,
  content BYTEA NOT NULL,
  CONSTRAINT pk_bar_resource PRIMARY KEY (id),
  CONSTRAINT uk_bar_resource_processid_name_type UNIQUE (process_id, name, type)
);

CREATE TABLE temporary_content (
  id INT8 NOT NULL,
  creationDate INT8 NOT NULL,
  key_ VARCHAR(255) NOT NULL,
  fileName VARCHAR(255) NOT NULL,
  mimeType VARCHAR(255) NOT NULL,
  content OID NOT NULL,
  UNIQUE (key_),
  PRIMARY KEY (id)
);
CREATE INDEX idx_temporary_content ON temporary_content (key_);

CREATE TABLE tenant_resource (
  id INT8 NOT NULL,
  name VARCHAR(255) NOT NULL,
  type VARCHAR(16) NOT NULL,
  content BYTEA NOT NULL,
  lastUpdatedBy INT8 NOT NULL,
  lastUpdateDate INT8,
  state VARCHAR(50) NOT NULL,
  CONSTRAINT pk_tenant_resource PRIMARY KEY (id),
  CONSTRAINT uk_tenant_resource_name_type UNIQUE (name, type)
);

CREATE TABLE bpm_failure (
  id INT8 NOT NULL,
  processDefinitionId INT8 NOT NULL,
  processInstanceId INT8 NOT NULL,
  rootProcessInstanceId INT8,
  flowNodeInstanceId INT8,
  scope VARCHAR(255),
  context VARCHAR(1024),
  errorMessage VARCHAR(1024),
  stackTrace TEXT,
  failureDate INT8 NOT NULL,
  CONSTRAINT pk_bpm_failure PRIMARY KEY (id)
);
CREATE INDEX idx_bpm_failure_flownodeinstanceid ON bpm_failure (flowNodeInstanceId);
CREATE INDEX idx_bpm_failure_processinstanceid ON bpm_failure (processInstanceId);
CREATE INDEX idx_bpm_failure_rootprocessinstanceid ON bpm_failure (rootProcessInstanceId);
CREATE INDEX idx_bpm_failure_processdefinitionid ON bpm_failure (processDefinitionId);

CREATE TABLE arch_bpm_failure (
  id INT8 NOT NULL,
  processDefinitionId INT8 NOT NULL,
  processInstanceId INT8 NOT NULL,
  rootProcessInstanceId INT8,
  flowNodeInstanceId INT8,
  scope VARCHAR(255),
  context VARCHAR(1024),
  errorMessage VARCHAR(1024),
  stackTrace TEXT,
  failureDate INT8 NOT NULL,
  archiveDate INT8 NOT NULL,
  sourceObjectId INT8 NOT NULL,
  CONSTRAINT pk_arch_bpm_failure PRIMARY KEY (id)
);
CREATE INDEX idx_arch_bpm_failure_flownodeinstanceid ON arch_bpm_failure (flowNodeInstanceId);
CREATE INDEX idx_arch_bpm_failure_processinstanceid ON arch_bpm_failure (processInstanceId);
CREATE INDEX idx_arch_bpm_failure_rootprocessinstanceid ON arch_bpm_failure (rootProcessInstanceId);
CREATE INDEX idx_arch_bpm_failure_processdefinitionid ON arch_bpm_failure (processDefinitionId);