/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.business.application.exporter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.bonitasoft.engine.business.application.xml.ApplicationNodeContainer;
import org.xml.sax.SAXException;

public class ApplicationNodeContainerConverter {
    private static final String APPLICATION_XSD = "/application.xsd";

    public byte[] marshallToXML(ApplicationNodeContainer applicationNodeContainer) throws JAXBException, IOException, SAXException {
        return this.marshallObjectToXML(applicationNodeContainer);
    }

    public ApplicationNodeContainer unmarshallFromXML(byte[] applicationXML) throws JAXBException, IOException, SAXException {
        return this.unmarshallXMLtoObject(applicationXML);
    }

    private byte[] marshallObjectToXML(ApplicationNodeContainer jaxbModel) throws JAXBException, IOException, SAXException {
        if (jaxbModel == null) {
            return new byte[0];
        }
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(ApplicationNodeContainer.class.getResource(APPLICATION_XSD));
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{jaxbModel.getClass()});
            Marshaller m = contextObj.createMarshaller();
            m.setSchema(schema);
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
            m.marshal((Object)jaxbModel, (OutputStream)stream);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }

    private ApplicationNodeContainer unmarshallXMLtoObject(byte[] xmlObject) throws JAXBException, IOException, SAXException {
        if (xmlObject == null) {
            return null;
        }
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(ApplicationNodeContainer.class.getResource(APPLICATION_XSD));
        JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{ApplicationNodeContainer.class});
        Unmarshaller um = contextObj.createUnmarshaller();
        um.setSchema(schema);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(xmlObject);){
            JAXBElement jaxbElement = um.unmarshal((Source)new StreamSource(stream), ApplicationNodeContainer.class);
            ApplicationNodeContainer applicationNodeContainer = (ApplicationNodeContainer)jaxbElement.getValue();
            return applicationNodeContainer;
        }
    }
}

