/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.bonitasoft.engine.api.APIAccessor;
import org.bonitasoft.engine.api.ApiAccessType;
import org.bonitasoft.engine.api.HTTPServerAPI;
import org.bonitasoft.engine.api.PlatformAPI;
import org.bonitasoft.engine.api.PlatformCommandAPI;
import org.bonitasoft.engine.api.PlatformLoginAPI;
import org.bonitasoft.engine.api.TemporaryContentAPI;
import org.bonitasoft.engine.api.impl.ClientInterceptor;
import org.bonitasoft.engine.api.impl.LocalServerAPIFactory;
import org.bonitasoft.engine.api.internal.ServerAPI;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.session.PlatformSession;
import org.bonitasoft.engine.session.Session;
import org.bonitasoft.engine.util.APITypeManager;

public class PlatformAPIAccessor {
    static ServerAPI getServerAPI() throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        try {
            ApiAccessType apiType = APITypeManager.getAPIType();
            switch (apiType) {
                case LOCAL: {
                    return LocalServerAPIFactory.getServerAPI();
                }
                case HTTP: {
                    Map<String, String> parameters = APITypeManager.getAPITypeParameters();
                    return new HTTPServerAPI(parameters);
                }
            }
            throw new UnknownAPITypeException("Unsupported API Type: " + apiType);
        }
        catch (IOException e) {
            throw new ServerAPIException((Throwable)e);
        }
    }

    public static void refresh() {
        APITypeManager.refresh();
    }

    public static PlatformLoginAPI getPlatformLoginAPI() throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return PlatformAPIAccessor.getAPI(PlatformLoginAPI.class);
    }

    static <T> T getAPI(Class<T> clazz, PlatformSession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        ServerAPI serverAPI = PlatformAPIAccessor.getServerAPI();
        ClientInterceptor sessionInterceptor = new ClientInterceptor(clazz.getName(), serverAPI, (Session)session);
        return (T)Proxy.newProxyInstance(APIAccessor.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)sessionInterceptor);
    }

    static <T> T getAPI(Class<T> clazz) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        ServerAPI serverAPI = PlatformAPIAccessor.getServerAPI();
        ClientInterceptor sessionInterceptor = new ClientInterceptor(clazz.getName(), serverAPI);
        return (T)Proxy.newProxyInstance(APIAccessor.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)sessionInterceptor);
    }

    public static PlatformAPI getPlatformAPI(PlatformSession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return PlatformAPIAccessor.getAPI(PlatformAPI.class, session);
    }

    public static PlatformCommandAPI getPlatformCommandAPI(PlatformSession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return PlatformAPIAccessor.getAPI(PlatformCommandAPI.class, session);
    }

    public static TemporaryContentAPI getTemporaryContentAPI() throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return PlatformAPIAccessor.getAPI(TemporaryContentAPI.class);
    }
}

