/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.bonitasoft.engine.bdm.BusinessObjectDaoCreationException;
import org.bonitasoft.engine.bdm.dao.BusinessObjectDAO;
import org.bonitasoft.engine.session.APISession;

public class BusinessObjectDAOFactory {
    private static final String IMPL_SUFFIX = "Impl";

    public <T extends BusinessObjectDAO> T createDAO(APISession session, Class<T> daoInterface) throws BusinessObjectDaoCreationException {
        if (session == null) {
            throw new IllegalArgumentException("session is null");
        }
        if (daoInterface == null) {
            throw new IllegalArgumentException("daoInterface is null");
        }
        if (!daoInterface.isInterface()) {
            throw new IllegalArgumentException(daoInterface.getName() + " is not an interface");
        }
        String daoClassName = daoInterface.getName();
        Class<T> daoImplClass = null;
        try {
            daoImplClass = this.loadClass(daoClassName);
        }
        catch (ClassNotFoundException e) {
            throw new BusinessObjectDaoCreationException(e);
        }
        if (daoImplClass != null) {
            try {
                Constructor<T> constructor = daoImplClass.getConstructor(APISession.class);
                return (T)((BusinessObjectDAO)constructor.newInstance(session));
            }
            catch (SecurityException e) {
                throw new BusinessObjectDaoCreationException(e);
            }
            catch (NoSuchMethodException e) {
                throw new BusinessObjectDaoCreationException(e);
            }
            catch (IllegalArgumentException e) {
                throw new BusinessObjectDaoCreationException(e);
            }
            catch (InstantiationException e) {
                throw new BusinessObjectDaoCreationException(e);
            }
            catch (IllegalAccessException e) {
                throw new BusinessObjectDaoCreationException(e);
            }
            catch (InvocationTargetException e) {
                throw new BusinessObjectDaoCreationException(e);
            }
        }
        return null;
    }

    protected <T extends BusinessObjectDAO> Class<T> loadClass(String daoClassName) throws ClassNotFoundException {
        return Class.forName(this.toDaoImplClassName(daoClassName), true, Thread.currentThread().getContextClassLoader());
    }

    private String toDaoImplClassName(String daoClassName) {
        return daoClassName + IMPL_SUFFIX;
    }
}

