/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bonitasoft.engine.api.TcpDestination;
import org.bonitasoft.engine.api.internal.ServerAPI;
import org.bonitasoft.engine.api.internal.ServerWrappedException;
import org.bonitasoft.engine.api.tcp.MethodCall;

public class TCPServerAPI
implements ServerAPI {
    private static final long serialVersionUID = 1L;
    private final List<TcpDestination> destinations = new ArrayList<TcpDestination>();
    private final Random random;

    public TCPServerAPI(Map<String, String> parameters) {
        String[] splittedDestinations;
        String destinationsList = parameters.get("destinations");
        for (String destination : splittedDestinations = destinationsList.split(",")) {
            this.destinations.add(this.getTcpdDestinationFromPattern(destination));
        }
        this.random = new Random();
    }

    private TcpDestination getTcpdDestinationFromPattern(String s) {
        int separatorIndex = s.indexOf(":");
        String host = s.substring(0, separatorIndex);
        int port = Integer.valueOf(s.substring(separatorIndex + 1));
        TcpDestination tcpDestination = new TcpDestination(host, port);
        return tcpDestination;
    }

    public Object invokeMethod(Map<String, Serializable> options, String apiInterfaceName, String methodName, List<String> classNameParameters, Object[] parametersValues) throws ServerWrappedException {
        Socket remoteServerAPI = null;
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            TcpDestination tcpDestination = this.destinations.get(this.random.nextInt(this.destinations.size()));
            remoteServerAPI = new Socket(tcpDestination.getHost(), tcpDestination.getPort());
            InputStream socketInputStream = remoteServerAPI.getInputStream();
            oos = new ObjectOutputStream(remoteServerAPI.getOutputStream());
            MethodCall methodCall = new MethodCall(options, apiInterfaceName, methodName, classNameParameters, parametersValues);
            oos.writeObject(methodCall);
            oos.flush();
            ois = new ObjectInputStream(socketInputStream);
            Object callReturn = ois.readObject();
            Object object = this.checkInvokeMethodReturn(callReturn);
            return object;
        }
        catch (Exception e) {
            throw new ServerWrappedException((Throwable)e);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (ois != null) {
                    ois.close();
                }
                if (remoteServerAPI != null) {
                    remoteServerAPI.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Object checkInvokeMethodReturn(Object callReturn) throws Exception {
        if (callReturn != null && callReturn instanceof Throwable) {
            Exception throwable = (Exception)callReturn;
            throw throwable;
        }
        return callReturn;
    }
}

