/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.bonitasoft.engine.api.APIAccessor;
import org.bonitasoft.engine.api.ApplicationAPI;
import org.bonitasoft.engine.api.BusinessDataAPI;
import org.bonitasoft.engine.api.CommandAPI;
import org.bonitasoft.engine.api.IdentityAPI;
import org.bonitasoft.engine.api.LoginAPI;
import org.bonitasoft.engine.api.PageAPI;
import org.bonitasoft.engine.api.PermissionAPI;
import org.bonitasoft.engine.api.PlatformAPIAccessor;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.ProfileAPI;
import org.bonitasoft.engine.api.TenantAdministrationAPI;
import org.bonitasoft.engine.api.ThemeAPI;
import org.bonitasoft.engine.api.impl.ClientInterceptor;
import org.bonitasoft.engine.api.internal.ServerAPI;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.Session;
import org.bonitasoft.engine.util.APITypeManager;

public final class TenantAPIAccessor {
    private static ServerAPI getServerAPI() throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return PlatformAPIAccessor.getServerAPI();
    }

    public static void refresh() {
        APITypeManager.refresh();
    }

    private static <T> T getAPI(Class<T> clazz, APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        ServerAPI serverAPI = TenantAPIAccessor.getServerAPI();
        ClientInterceptor sessionInterceptor = new ClientInterceptor(clazz.getName(), serverAPI, (Session)session);
        return (T)Proxy.newProxyInstance(APIAccessor.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)sessionInterceptor);
    }

    private static <T> T getAPI(Class<T> clazz) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        ServerAPI serverAPI = TenantAPIAccessor.getServerAPI();
        ClientInterceptor sessionInterceptor = new ClientInterceptor(clazz.getName(), serverAPI);
        return (T)Proxy.newProxyInstance(APIAccessor.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)sessionInterceptor);
    }

    public static LoginAPI getLoginAPI() throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getAPI(LoginAPI.class);
    }

    public static IdentityAPI getIdentityAPI(APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getAPI(IdentityAPI.class, session);
    }

    public static ProcessAPI getProcessAPI(APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getAPI(ProcessAPI.class, session);
    }

    public static CommandAPI getCommandAPI(APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getAPI(CommandAPI.class, session);
    }

    public static ProfileAPI getProfileAPI(APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getAPI(ProfileAPI.class, session);
    }

    @Deprecated(since="7.13.0")
    public static ThemeAPI getThemeAPI(APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getAPI(ThemeAPI.class, session);
    }

    public static PermissionAPI getPermissionAPI(APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getAPI(PermissionAPI.class, session);
    }

    public static PageAPI getCustomPageAPI(APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getAPI(PageAPI.class, session);
    }

    public static ApplicationAPI getLivingApplicationAPI(APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getAPI(ApplicationAPI.class, session);
    }

    public static TenantAdministrationAPI getTenantAdministrationAPI(APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getAPI(TenantAdministrationAPI.class, session);
    }

    @Deprecated
    public static BusinessDataAPI getBusinessDataAPI(APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getAPI(BusinessDataAPI.class, session);
    }

    public static ApplicationAPI getApplicationAPI(APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getAPI(ApplicationAPI.class, session);
    }
}

