/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.bonitasoft.engine.api.APIAccessor;
import org.bonitasoft.engine.api.ApiAccessType;
import org.bonitasoft.engine.api.ApplicationAPI;
import org.bonitasoft.engine.api.BusinessDataAPI;
import org.bonitasoft.engine.api.CommandAPI;
import org.bonitasoft.engine.api.EJB3ServerAPI;
import org.bonitasoft.engine.api.HTTPServerAPI;
import org.bonitasoft.engine.api.IdentityAPI;
import org.bonitasoft.engine.api.LoginAPI;
import org.bonitasoft.engine.api.PageAPI;
import org.bonitasoft.engine.api.PermissionAPI;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.ProfileAPI;
import org.bonitasoft.engine.api.TCPServerAPI;
import org.bonitasoft.engine.api.TenantAdministrationAPI;
import org.bonitasoft.engine.api.ThemeAPI;
import org.bonitasoft.engine.api.impl.ClientInterceptor;
import org.bonitasoft.engine.api.impl.LocalServerAPIFactory;
import org.bonitasoft.engine.api.internal.ServerAPI;
import org.bonitasoft.engine.bdm.BusinessObjectDaoCreationException;
import org.bonitasoft.engine.bdm.dao.BusinessObjectDAO;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.platform.LoginException;
import org.bonitasoft.engine.platform.LogoutException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.Session;
import org.bonitasoft.engine.session.SessionNotFoundException;
import org.bonitasoft.engine.util.APITypeManager;

public class APIClient {
    private static final String IMPL_SUFFIX = "Impl";
    protected APISession session;

    public APIClient() {
        this.session = null;
    }

    public APIClient(APISession session) {
        this.session = session;
    }

    public APISession getSession() {
        return this.session;
    }

    ServerAPI getServerAPI() throws ServerAPIException, UnknownAPITypeException {
        try {
            ApiAccessType apiType = APITypeManager.getAPIType();
            switch (apiType) {
                case LOCAL: {
                    return LocalServerAPIFactory.getServerAPI();
                }
                case EJB3: {
                    Map<String, String> parameters = APITypeManager.getAPITypeParameters();
                    return new EJB3ServerAPI(parameters);
                }
                case HTTP: {
                    Map<String, String> parameters = APITypeManager.getAPITypeParameters();
                    return new HTTPServerAPI(parameters);
                }
                case TCP: {
                    Map<String, String> parameters = APITypeManager.getAPITypeParameters();
                    return new TCPServerAPI(parameters);
                }
            }
            throw new UnknownAPITypeException("Unsupported API Type: " + (Object)((Object)apiType));
        }
        catch (IOException e) {
            throw new ServerAPIException((Throwable)e);
        }
    }

    protected <T> T getAPI(Class<T> apiClass) {
        this.ensureSessionExists();
        try {
            ClientInterceptor clientInterceptor = new ClientInterceptor(apiClass.getName(), this.getServerAPI(), (Session)this.session);
            Object api = Proxy.newProxyInstance(APIAccessor.class.getClassLoader(), new Class[]{apiClass}, (InvocationHandler)clientInterceptor);
            return (T)api;
        }
        catch (ServerAPIException | UnknownAPITypeException e) {
            throw new IllegalStateException(e.getMessage(), (Throwable)e);
        }
    }

    private void ensureSessionExists() {
        if (this.session == null) {
            throw new IllegalStateException("You must call login() prior to accessing any API.");
        }
    }

    protected LoginAPI getLoginAPI() {
        return this.getLoginAPI(LoginAPI.class);
    }

    protected <T extends LoginAPI> T getLoginAPI(Class<T> apiClass) {
        try {
            ClientInterceptor interceptor = new ClientInterceptor(apiClass.getName(), this.getServerAPI());
            LoginAPI api = (LoginAPI)Proxy.newProxyInstance(APIAccessor.class.getClassLoader(), new Class[]{apiClass}, (InvocationHandler)interceptor);
            return (T)api;
        }
        catch (ServerAPIException | UnknownAPITypeException e) {
            throw new IllegalStateException(e.getMessage(), (Throwable)e);
        }
    }

    public void login(String username, String password) throws LoginException {
        this.session = this.getLoginAPI(LoginAPI.class).login(username, password);
    }

    public void logout() throws LogoutException {
        try {
            if (this.session != null) {
                this.getLoginAPI().logout(this.session);
                this.session = null;
            }
        }
        catch (SessionNotFoundException sessionNotFoundException) {
            // empty catch block
        }
    }

    public <T extends BusinessObjectDAO> T getDAO(Class<T> daoInterface) throws BusinessObjectDaoCreationException {
        this.ensureSessionExists();
        if (daoInterface == null) {
            throw new IllegalArgumentException("daoInterface is null");
        }
        if (!daoInterface.isInterface()) {
            throw new IllegalArgumentException(daoInterface.getName() + " is not an interface");
        }
        try {
            Class<T> daoImplClass = this.loadClass(daoInterface);
            if (daoImplClass != null) {
                Constructor<T> constructor = daoImplClass.getConstructor(APISession.class);
                return (T)((BusinessObjectDAO)constructor.newInstance(this.session));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new BusinessObjectDaoCreationException(e);
        }
        throw new BusinessObjectDaoCreationException("No Implementation of the DAO available.");
    }

    protected <T extends BusinessObjectDAO> Class<T> loadClass(Class<T> daoInterface) throws ClassNotFoundException {
        String implementationClassName = daoInterface.getName() + IMPL_SUFFIX;
        return Class.forName(implementationClassName, true, Thread.currentThread().getContextClassLoader());
    }

    public IdentityAPI getIdentityAPI() {
        return this.getAPI(IdentityAPI.class);
    }

    public ProcessAPI getProcessAPI() {
        return this.getAPI(ProcessAPI.class);
    }

    public ThemeAPI getThemeAPI() {
        return this.getAPI(ThemeAPI.class);
    }

    public CommandAPI getCommandAPI() {
        return this.getAPI(CommandAPI.class);
    }

    public ProfileAPI getProfileAPI() {
        return this.getAPI(ProfileAPI.class);
    }

    public TenantAdministrationAPI getTenantAdministrationAPI() {
        return this.getAPI(TenantAdministrationAPI.class);
    }

    public PageAPI getCustomPageAPI() {
        return this.getAPI(PageAPI.class);
    }

    public ApplicationAPI getLivingApplicationAPI() {
        return this.getAPI(ApplicationAPI.class);
    }

    public PermissionAPI getPermissionAPI() {
        return this.getAPI(PermissionAPI.class);
    }

    public BusinessDataAPI getBusinessDataAPI() {
        return this.getAPI(BusinessDataAPI.class);
    }
}

