/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.bonitasoft.engine.api.impl.XmlConverter;
import org.bonitasoft.engine.api.internal.ServerAPI;
import org.bonitasoft.engine.api.internal.ServerWrappedException;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.exception.StackTraceTransformer;

public class HTTPServerAPI
implements ServerAPI {
    private static final long serialVersionUID = -3375874140999200702L;
    private static final ContentType XML_UTF_8 = ContentType.create((String)"application/xml", (Charset)StandardCharsets.UTF_8);
    private static final String CLASS_NAME_PARAMETERS = "classNameParameters";
    private static final String OPTIONS = "options";
    private static final String PARAMETERS_VALUES = "parametersValues";
    private static final String BINARY_PARAMETER = "binaryParameter";
    private static final String BYTE_ARRAY = "==ByteArray==";
    private static final char SLASH = '/';
    private static final String SERVER_API = "/serverAPI/";
    static final String SERVER_URL = "server.url";
    private static final String BASIC_AUTHENTICATION_ACTIVE = "basicAuthentication.active";
    private static final String BASIC_AUTHENTICATION_USERNAME = "basicAuthentication.username";
    private static final String BASIC_AUTHENTICATION_PASSWORD = "basicAuthentication.password";
    static final String APPLICATION_NAME = "application.name";
    private final String serverUrl;
    private final String applicationName;
    private final boolean basicAuthenticationActive;
    private final String basicAuthenticationUserName;
    private final String basicAuthenticationPassword;
    private static DefaultHttpClient httpclient;
    private static final ResponseHandler<String> RESPONSE_HANDLER;
    private final XmlConverter xmlConverter = new XmlConverter();

    public HTTPServerAPI(Map<String, String> parameters) {
        if (httpclient == null) {
            httpclient = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager());
        }
        this.serverUrl = parameters.get(SERVER_URL);
        this.applicationName = parameters.get(APPLICATION_NAME);
        this.basicAuthenticationActive = "true".equalsIgnoreCase(parameters.get(BASIC_AUTHENTICATION_ACTIVE));
        this.basicAuthenticationUserName = parameters.get(BASIC_AUTHENTICATION_USERNAME);
        this.basicAuthenticationPassword = parameters.get(BASIC_AUTHENTICATION_PASSWORD);
    }

    public Object invokeMethod(Map<String, Serializable> options, String apiInterfaceName, String methodName, List<String> classNameParameters, Object[] parametersValues) throws ServerWrappedException {
        String response = null;
        try {
            response = this.executeHttpPost(options, apiInterfaceName, methodName, classNameParameters, parametersValues);
            return this.checkInvokeMethodReturn(response);
        }
        catch (UndeclaredThrowableException e) {
            throw new ServerWrappedException((Throwable)e);
        }
        catch (Throwable e) {
            StackTraceElement[] stackTrace = new Exception().getStackTrace();
            StackTraceTransformer.addStackTo((Throwable)e, (StackTraceElement[])stackTrace);
            throw new ServerWrappedException(e.getMessage() + " / response: " + response, e);
        }
    }

    Object checkInvokeMethodReturn(String response) throws Throwable {
        Object invokeMethodReturn = null;
        if (response != null && !response.isEmpty() && !"null".equals(response) && (invokeMethodReturn = this.xmlConverter.fromXML(response)) instanceof Throwable) {
            throw (Throwable)invokeMethodReturn;
        }
        return invokeMethodReturn;
    }

    String executeHttpPost(Map<String, Serializable> options, String apiInterfaceName, String methodName, List<String> classNameParameters, Object[] parametersValues) throws IOException {
        HttpPost httpost = this.createHttpPost(options, apiInterfaceName, methodName, classNameParameters, parametersValues);
        try {
            return (String)httpclient.execute((HttpUriRequest)httpost, RESPONSE_HANDLER);
        }
        catch (ClientProtocolException e) {
            String httpCodeMessage = "";
            if (e instanceof HttpResponseException) {
                int statusCode = ((HttpResponseException)e).getStatusCode();
                httpCodeMessage = String.format(" (http code: %s)", statusCode);
            }
            throw new IOException("Error while executing POST request" + httpCodeMessage + " <" + httpost + ">", e);
        }
    }

    private final HttpPost createHttpPost(Map<String, Serializable> options, String apiInterfaceName, String methodName, List<String> classNameParameters, Object[] parametersValues) throws IOException {
        HttpEntity httpEntity = this.buildEntity(options, classNameParameters, parametersValues);
        StringBuilder sBuilder = new StringBuilder(this.serverUrl);
        sBuilder.append('/').append(this.applicationName).append(SERVER_API).append(apiInterfaceName).append('/').append(methodName);
        HttpPost httpPost = new HttpPost(sBuilder.toString());
        httpPost.setEntity(httpEntity);
        if (this.basicAuthenticationActive) {
            StringBuilder credentials = new StringBuilder();
            credentials.append(this.basicAuthenticationUserName).append(":").append(this.basicAuthenticationPassword);
            Base64 encoder = new Base64();
            String encodedCredentials = encoder.encodeAsString(credentials.toString().getBytes("UTF-8"));
            httpPost.setHeader("Authorization", "Basic " + encodedCredentials);
        }
        return httpPost;
    }

    final HttpEntity buildEntity(Map<String, Serializable> options, List<String> classNameParameters, Object[] parametersValues) throws IOException {
        UrlEncodedFormEntity httpEntity;
        if (classNameParameters.contains(BusinessArchive.class.getName()) || classNameParameters.contains(byte[].class.getName())) {
            int i;
            ArrayList<Object> bytearrayParameters = new ArrayList<Object>();
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().setBoundary(null).setCharset(StandardCharsets.UTF_8);
            entityBuilder.addPart(OPTIONS, (ContentBody)new StringBody(this.xmlConverter.toXML(options), XML_UTF_8));
            entityBuilder.addPart(CLASS_NAME_PARAMETERS, (ContentBody)new StringBody(this.xmlConverter.toXML(classNameParameters), XML_UTF_8));
            for (i = 0; i < parametersValues.length; ++i) {
                Object parameterValue = parametersValues[i];
                if (!(parameterValue instanceof BusinessArchive) && !(parameterValue instanceof byte[])) continue;
                parametersValues[i] = BYTE_ARRAY;
                bytearrayParameters.add(parameterValue);
            }
            entityBuilder.addPart(PARAMETERS_VALUES, (ContentBody)new StringBody(this.xmlConverter.toXML(parametersValues), XML_UTF_8));
            i = 0;
            for (Object e : bytearrayParameters) {
                entityBuilder.addPart(BINARY_PARAMETER + i, (ContentBody)new ByteArrayBody(HTTPServerAPI.serialize(e), BINARY_PARAMETER + i));
                ++i;
            }
            httpEntity = entityBuilder.build();
        } else {
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair(OPTIONS, this.xmlConverter.toXML(options)));
            nvps.add(new BasicNameValuePair(CLASS_NAME_PARAMETERS, this.xmlConverter.toXML(classNameParameters)));
            nvps.add(new BasicNameValuePair(PARAMETERS_VALUES, this.xmlConverter.toXML(parametersValues)));
            httpEntity = new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8.name());
        }
        return httpEntity;
    }

    private static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ObjectOutputStream o = new ObjectOutputStream(b);
        o.writeObject(obj);
        return b.toByteArray();
    }

    static {
        RESPONSE_HANDLER = new BasicResponseHandler();
    }
}

