/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.bonitasoft.engine.api.ApiAccessType;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.io.PropertiesManager;

public class APITypeManager {
    private static final Logger LOGGER = Logger.getLogger(APITypeManager.class.getName());
    private static final String API_TYPE = "org.bonitasoft.engine.api-type";
    private static ApiAccessType apiAccessType = null;
    private static Map<String, String> apiTypeParameters = null;

    public static ApiAccessType getAPIType() throws ServerAPIException, UnknownAPITypeException, IOException {
        if (apiAccessType == null) {
            String apiType = APITypeManager.getAPITypeFromProperties();
            if (ApiAccessType.LOCAL.name().equalsIgnoreCase(apiType)) {
                apiAccessType = ApiAccessType.LOCAL;
            } else if (ApiAccessType.EJB3.name().equalsIgnoreCase(apiType)) {
                APITypeManager.warnEJB3IsDeprecated();
                apiAccessType = ApiAccessType.EJB3;
            } else if (ApiAccessType.HTTP.name().equalsIgnoreCase(apiType)) {
                apiAccessType = ApiAccessType.HTTP;
            } else if (ApiAccessType.TCP.name().equalsIgnoreCase(apiType)) {
                apiAccessType = ApiAccessType.TCP;
            } else {
                throw new UnknownAPITypeException("Invalid API type: " + apiType);
            }
        }
        return apiAccessType;
    }

    private static void warnEJB3IsDeprecated() {
        LOGGER.warning("EJB communication protocol is Deprecated and will be removed in 7.10");
    }

    private static String getAPITypeFromProperties() throws IOException {
        String property = APITypeManager.getProperties().get(API_TYPE);
        if (property != null) {
            return property;
        }
        return ApiAccessType.LOCAL.name();
    }

    public static Map<String, String> getAPITypeParameters() throws ServerAPIException, IOException {
        if (apiTypeParameters == null) {
            Map<String, String> properties = APITypeManager.getProperties();
            apiTypeParameters = new HashMap<String, String>(properties.size());
            for (Map.Entry<String, String> property : properties.entrySet()) {
                if (API_TYPE.equals(property.getKey())) continue;
                apiTypeParameters.put(property.getKey(), property.getValue());
            }
        }
        return apiTypeParameters;
    }

    public static void setAPITypeAndParams(ApiAccessType type, Map<String, String> parameters) {
        APITypeManager.warnIfUsingRemoteConnectionWithLocalEngine(type);
        if (ApiAccessType.EJB3 == type) {
            APITypeManager.warnEJB3IsDeprecated();
        }
        apiAccessType = type;
        apiTypeParameters = new HashMap<String, String>();
        if (parameters != null) {
            apiTypeParameters.putAll(parameters);
        }
    }

    private static void warnIfUsingRemoteConnectionWithLocalEngine(ApiAccessType type) {
        if (type != null && type != ApiAccessType.LOCAL) {
            try {
                Thread.currentThread().getContextClassLoader().loadClass("org.bonitasoft.engine.api.impl.ProcessAPIImpl");
                LOGGER.warning("You are declaring an API access to Bonita Engine as a remote connection, whereas it looks like you are running in the same JVM. You should use LOCAL connection, using constant 'ApiAccessType.LOCAL'");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private static Map<String, String> getProperties() throws IOException {
        Map<String, String> properties = APITypeManager.getPropertiesFromSystemProperties();
        Properties propertiesFromBonitaHome = APITypeManager.getPropertiesFromBonitaHome();
        for (String property : propertiesFromBonitaHome.stringPropertyNames()) {
            if (properties.containsKey(property)) continue;
            properties.put(property, propertiesFromBonitaHome.getProperty(property));
        }
        return properties;
    }

    private static Map<String, String> getPropertiesFromSystemProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        String apiType = System.getProperty(API_TYPE);
        if (apiType != null) {
            properties.put(API_TYPE, apiType);
        }
        APITypeManager.addParameter(properties, "org.bonitasoft.engine.api-type.", "server.url");
        APITypeManager.addParameter(properties, "org.bonitasoft.engine.api-type.", "application.name");
        APITypeManager.addParameter(properties, "org.bonitasoft.engine.api-type.", "connections.max");
        APITypeManager.addParameter(properties, "", "org.bonitasoft.engine.ejb.naming.reference");
        APITypeManager.addParameter(properties, "", "java.naming.factory.url.pkgs");
        return properties;
    }

    private static void addParameter(Map<String, String> properties, String parameterPrefix, String parameterName) {
        String parameter = System.getProperty(parameterPrefix + parameterName);
        if (parameter != null) {
            properties.put(parameterName, parameter);
        }
    }

    private static Properties getPropertiesFromBonitaHome() throws IOException {
        String bonitaHomePath = System.getProperty("bonita.home");
        if (bonitaHomePath == null || bonitaHomePath.isEmpty()) {
            return new Properties();
        }
        File clientFolder = new File(bonitaHomePath.trim(), "engine-client");
        Properties result = new Properties();
        APITypeManager.addPropertiesFrom(clientFolder, result, "work", "bonita-client-community.properties");
        APITypeManager.addPropertiesFrom(clientFolder, result, "conf", "bonita-client-custom.properties");
        return result;
    }

    private static void addPropertiesFrom(File clientFolder, Properties result, String ... strings) throws IOException {
        File folder = FileUtils.getFile((File)clientFolder, (String[])strings);
        if (folder.exists()) {
            Properties defaultProperties = PropertiesManager.getProperties((File)folder);
            result.putAll((Map<?, ?>)defaultProperties);
        }
    }

    public static void refresh() {
        apiAccessType = null;
        apiTypeParameters = null;
    }
}

