/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.activation.MimetypesFileTypeMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.bonitasoft.engine.commons.ClassDataUtil;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.commons.Pair;
import org.w3c.dom.Document;

public class IOUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String TMP_DIRECTORY = System.getProperty("java.io.tmpdir");
    public static final MimetypesFileTypeMap MIMETYPES_FILE_TYPE_MAP = new MimetypesFileTypeMap();
    private static final int BUFFER_SIZE = 100000;
    public static final String FILE_ENCODING = "UTF-8";

    private IOUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getClassNameList(byte[] jarContent) throws IOException {
        ArrayList<String> classes = new ArrayList<String>(10);
        ZipInputStream stream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(jarContent);
            stream = new JarInputStream(byteArrayInputStream);
            JarEntry nextJarEntry = null;
            while ((nextJarEntry = ((JarInputStream)stream).getNextJarEntry()) != null) {
                String name = nextJarEntry.getName();
                if (!name.endsWith(".class")) continue;
                classes.add(IOUtil.toQualifiedClassName(name));
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
        }
        return classes;
    }

    private static String toQualifiedClassName(String name) {
        return name.replace('/', '.').replaceAll(".class", "");
    }

    public static void write(File file, byte[] fileContent) throws IOException {
        NullCheckingUtil.checkArgsNotNull(file, fileContent);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        try (FileOutputStream os = new FileOutputStream(file);){
            ((OutputStream)os).write(fileContent);
            os.flush();
        }
    }

    public static byte[] generateJar(Class<?> ... classes) throws IOException {
        return IOUtil.generateJar(IOUtil.getResources(classes));
    }

    public static Map<String, byte[]> getResources(Class<?> ... classes) throws IOException {
        if (classes == null || classes.length == 0) {
            String message = "No classes available";
            throw new IOException("No classes available");
        }
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        for (Class<?> clazz : classes) {
            resources.put(clazz.getName().replace(".", "/") + ".class", ClassDataUtil.getClassData(clazz));
            for (Class<?> internalClass : clazz.getDeclaredClasses()) {
                resources.put(internalClass.getName().replace(".", "/") + ".class", ClassDataUtil.getClassData(internalClass));
            }
        }
        return resources;
    }

    public static byte[] generateJar(Map<String, byte[]> resources) throws IOException {
        if (resources == null || resources.isEmpty()) {
            throw new IOException("No resources available");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Object object;
            try (JarOutputStream jarOutStream = new JarOutputStream(new BufferedOutputStream(baos));){
                for (Map.Entry<String, byte[]> resource : resources.entrySet()) {
                    JarEntry entry = new JarEntry(resource.getKey());
                    entry.setCreationTime(FileTime.from(Instant.ofEpochMilli(0L)));
                    entry.setLastModifiedTime(FileTime.from(Instant.ofEpochMilli(0L)));
                    entry.setLastAccessTime(FileTime.from(Instant.ofEpochMilli(0L)));
                    entry.setTimeLocal(LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC));
                    entry.setTime(0L);
                    jarOutStream.putNextEntry(entry);
                    jarOutStream.write(resource.getValue());
                }
                jarOutStream.flush();
                baos.flush();
                baos.close();
                jarOutStream.close();
                object = baos.toByteArray();
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateZip(Map<String, byte[]> resources) throws IOException {
        if (resources == null || resources.isEmpty()) {
            throw new IOException("No resources available");
        }
        ByteArrayOutputStream baos = null;
        ZipOutputStream zipOutStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            baos = new ByteArrayOutputStream();
            bufferedOutputStream = new BufferedOutputStream(baos);
            zipOutStream = new ZipOutputStream(bufferedOutputStream);
            for (Map.Entry<String, byte[]> resource : resources.entrySet()) {
                zipOutStream.putNextEntry(new ZipEntry(resource.getKey()));
                zipOutStream.write(resource.getValue());
            }
            zipOutStream.flush();
            baos.flush();
        }
        finally {
            if (zipOutStream != null) {
                zipOutStream.close();
            }
            if (baos != null) {
                baos.close();
            }
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
            }
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(InputStream in) throws IOException {
        byte[] resultArray;
        if (in == null) {
            throw new IOException("The InputStream is null!");
        }
        byte[] buffer = new byte[100000];
        BufferedInputStream bis = null;
        ByteArrayOutputStream result = null;
        try {
            int amountRead;
            bis = new BufferedInputStream(in);
            result = new ByteArrayOutputStream();
            while ((amountRead = bis.read(buffer)) > 0) {
                result.write(buffer, 0, amountRead);
            }
            resultArray = result.toByteArray();
            result.flush();
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (result != null) {
                result.close();
            }
        }
        return resultArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream inputStream) {
        StringBuilder text = new StringBuilder();
        try (Scanner scanner = new Scanner(inputStream, FILE_ENCODING);){
            boolean isFirst = true;
            while (scanner.hasNextLine()) {
                if (isFirst) {
                    text.append(scanner.nextLine());
                } else {
                    text.append(LINE_SEPARATOR + scanner.nextLine());
                }
                isFirst = false;
            }
        }
        return text.toString();
    }

    public static String read(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            String string = IOUtil.read(inputStream);
            return string;
        }
    }

    public static byte[] getAllContentFrom(File file) throws IOException {
        try (FileInputStream in = null;){
            in = new FileInputStream(file);
            byte[] byArray = IOUtil.getAllContentFrom(in);
            return byArray;
        }
    }

    public static byte[] getAllContentFrom(URL url) throws IOException {
        try (InputStream in = url.openStream();){
            byte[] byArray = IOUtil.getAllContentFrom(in);
            return byArray;
        }
    }

    public static boolean deleteDir(File dir) throws IOException {
        return IOUtil.deleteDir(dir, 1, 0L);
    }

    public static boolean deleteDir(File dir, int attempts, long sleepTime) throws IOException {
        boolean result = true;
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            throw new IOException("Unable to delete directory: " + dir + ", it is not a directory");
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                result &= IOUtil.deleteDir(file, attempts, sleepTime);
                continue;
            }
            result &= IOUtil.deleteFile(file, attempts, sleepTime);
        }
        return result && IOUtil.deleteFile(dir, attempts, sleepTime);
    }

    public static boolean deleteFile(File file, int attempts, long sleepTime) {
        int retries = attempts;
        while (retries > 0 && !file.delete()) {
            --retries;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        return retries > 0;
    }

    public static void writeFile(File file, String fileContent) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist: " + file);
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + file);
        }
        try (BufferedWriter output = new BufferedWriter(new FileWriter(file));){
            output.write(fileContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zip(Map<String, byte[]> files) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            for (Map.Entry<String, byte[]> file : files.entrySet()) {
                zos.putNextEntry(new ZipEntry(file.getKey()));
                zos.write(file.getValue());
                zos.flush();
                zos.closeEntry();
            }
        }
        finally {
            zos.close();
            baos.close();
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zip(Pair<String, byte[]> ... files) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            for (Pair<String, byte[]> file : files) {
                zos.putNextEntry(new ZipEntry((String)file.getKey()));
                zos.write((byte[])file.getValue());
                zos.flush();
                zos.closeEntry();
            }
        }
        finally {
            zos.close();
            baos.close();
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Map<String, byte[]> unzip(byte[] zipFile) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(zipFile);
        ZipInputStream zipInputstream = new ZipInputStream(bais);
        ZipEntry zipEntry = null;
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        try {
            while ((zipEntry = zipInputstream.getNextEntry()) != null) {
                int bytesRead;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[100000];
                while ((bytesRead = zipInputstream.read(buffer)) > -1) {
                    byteArrayOutputStream.write(buffer, 0, bytesRead);
                }
                files.put(zipEntry.getName(), byteArrayOutputStream.toByteArray());
            }
        }
        finally {
            zipInputstream.close();
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeZipInputToFile(ZipInputStream zipInputstream, File outputFile) throws FileNotFoundException, IOException {
        IOUtil.mkdirs(outputFile.getParentFile());
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
            int bytesRead;
            byte[] buffer = new byte[100000];
            while ((bytesRead = zipInputstream.read(buffer)) > -1) {
                fileOutputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException ioe) {
            outputFile.delete();
            throw ioe;
        }
    }

    private static boolean mkdirs(File file) {
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getZipEntryContent(String entryName, InputStream inputStream) throws IOException {
        ZipEntry zipEntry = null;
        try (ZipInputStream zipInputstream = new ZipInputStream(inputStream);){
            while ((zipEntry = zipInputstream.getNextEntry()) != null) {
                if (!entryName.equals(zipEntry.getName())) continue;
                byte[] byArray = IOUtil.getBytes(zipInputstream);
                return byArray;
            }
        }
        throw new IOException("Entry " + entryName + " does not exists in the zip file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(ZipInputStream zipInputstream) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[100000];
            while ((bytesRead = zipInputstream.read(buffer)) > -1) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static byte[] getZipEntryContent(String entryName, byte[] zipFile) throws IOException {
        return IOUtil.getZipEntryContent(entryName, new ByteArrayInputStream(zipFile));
    }

    public static byte[] toByteArray(Document document) throws IOException, TransformerException {
        if (document == null) {
            throw new IllegalArgumentException("Document should not be null.");
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Transformer tf = transformerFactory.newTransformer();
        tf.setOutputProperty("encoding", FILE_ENCODING);
        tf.setOutputProperty("indent", "yes");
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            tf.transform(new DOMSource(document), new StreamResult(out));
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] addJarEntry(byte[] jarToUpdate, String entryName, byte[] entryContent) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] getPropertyAsString(Properties prop, String comment) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        prop.store(out, comment);
        return out.toByteArray();
    }

    public static String readResource(String fileName) throws IOException {
        String xmlContent;
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        if (inputStream == null) {
            return null;
        }
        try {
            xmlContent = IOUtil.read(inputStream);
        }
        finally {
            inputStream.close();
        }
        return xmlContent;
    }

    public static String md5(byte[] content) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        return new BigInteger(1, md5.digest(content)).toString(16);
    }

    public static void writeMD5(File file, byte[] bytes) throws NoSuchAlgorithmException, IOException {
        IOUtil.write(file, IOUtil.md5(bytes).getBytes());
    }

    public static boolean checkMD5(File md5File, byte[] contentToCheck) throws NoSuchAlgorithmException {
        if (!md5File.exists()) {
            return false;
        }
        try {
            return IOUtil.read(md5File).equals(IOUtil.md5(contentToCheck));
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePropertyValue(File propertiesFile, Map<String, String> pairs) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(propertiesFile));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                String key;
                int splitCharIndex;
                Object lineToWrite = line;
                if (!line.startsWith("#") && (splitCharIndex = line.indexOf("=")) >= 0 && pairs.containsKey((key = line.substring(0, splitCharIndex)).trim())) {
                    String value = pairs.get(key.trim());
                    value = value.replace("\\", "\\\\");
                    lineToWrite = key + "=" + value;
                }
                sb.append((String)lineToWrite);
                sb.append(System.lineSeparator());
                line = br.readLine();
            }
            IOUtil.writeFile(propertiesFile, sb.toString());
        }
    }

    public static String getContentTypeForIcon(String iconFilename) {
        String contentType = MIMETYPES_FILE_TYPE_MAP.getContentType(iconFilename);
        if (!contentType.startsWith("image")) {
            throw new IllegalArgumentException("An icon can't have mimetype " + contentType);
        }
        return contentType;
    }

    public static Optional<byte[]> getFileContent(String fileName) throws IOException {
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);){
            if (inputStream == null) {
                Optional<byte[]> optional = Optional.empty();
                return optional;
            }
            Optional<byte[]> optional = Optional.of(IOUtil.getAllContentFrom(inputStream));
            return optional;
        }
    }

    public static File createTempDirectory(URI directoryPath) {
        File tmpDir = new File(directoryPath);
        tmpDir.setReadable(true);
        tmpDir.setWritable(true);
        IOUtil.mkdirs(tmpDir);
        FileUtils.isSymlink((File)tmpDir);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    boolean deleted = IOUtil.deleteDir(tmpDir);
                    if (!deleted) {
                        System.err.println("Unable to delete directory: " + tmpDir + ". Trying with an alternative force delete.");
                        FileUtils.forceDelete((File)tmpDir);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return tmpDir;
    }

    static {
        MIMETYPES_FILE_TYPE_MAP.addMimeTypes("image/png\t\tpng PNG");
        MIMETYPES_FILE_TYPE_MAP.addMimeTypes("image/gif\t\tgif GIF");
        MIMETYPES_FILE_TYPE_MAP.addMimeTypes("image/jpeg\t\tjpeg jpg jpe JPG");
    }
}

