/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.service;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class TaskResult<T> {
    private Throwable throwable;
    private T result;
    private Long timeout;
    private TimeUnit timeunit;

    public TaskResult(Throwable e) {
        this.throwable = e;
    }

    public TaskResult(T result) {
        this.result = result;
    }

    public TaskResult(Long timeout, TimeUnit timeunit) {
        this.timeout = timeout;
        this.timeunit = timeunit;
    }

    public static <T> TaskResult<T> error(Throwable e) {
        return new TaskResult<T>(e);
    }

    public static <T> TaskResult<T> ok(T result) {
        return new TaskResult<T>(result);
    }

    public static <T> TaskResult<T> timeout(long timeout, TimeUnit timeunit) {
        return new TaskResult<T>(timeout, timeunit);
    }

    public boolean isError() {
        return this.throwable != null;
    }

    public boolean isOk() {
        return !this.isError() && !this.isTimeout();
    }

    public boolean isTimeout() {
        return this.timeout != null;
    }

    public T getResult() {
        return this.result;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeunit() {
        return this.timeunit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskResult that = (TaskResult)o;
        return Objects.equals(this.throwable, that.throwable) && Objects.equals(this.result, that.result) && Objects.equals(this.timeout, that.timeout) && this.timeunit == that.timeunit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.throwable, this.result, this.timeout, this.timeunit});
    }

    public String toString() {
        return "TaskResult{throwable=" + this.throwable + ", result=" + this.result + ", timeout=" + this.timeout + ", timeunit=" + this.timeunit + "}";
    }
}

