/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.mdc;

import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import org.bonitasoft.engine.mdc.AbstractMDC;
import org.slf4j.MDC;

public class MDCHelper {
    private static Map<Object, MDCHelper> instances = new WeakHashMap<Object, MDCHelper>();
    private Supplier<? extends AbstractMDC> supplier;

    private MDCHelper(Supplier<? extends AbstractMDC> mdcSupplier) {
        this.supplier = mdcSupplier;
    }

    public static Supplier<? extends AbstractMDC> makeCurrentContextSupplier() {
        Map contextMap = MDC.getCopyOfContextMap();
        return () -> new AbstractMDC(contextMap){};
    }

    public static void supplyMDC(Supplier<? extends AbstractMDC> mdcSupplier, Object usingObject) {
        MDCHelper.supplyMDC(mdcSupplier, usingObject, true);
    }

    public static void supplyMDC(Supplier<? extends AbstractMDC> mdcSupplier, Object usingObject, boolean overwrite) {
        if (overwrite) {
            instances.put(usingObject, new MDCHelper(mdcSupplier));
        } else {
            instances.computeIfAbsent(usingObject, k -> new MDCHelper(mdcSupplier));
        }
    }

    public static AbstractMDC getMDC(Object usingObject) {
        Optional<MDCHelper> helper = MDCHelper.getHelper(usingObject);
        return helper.map(h -> h.supplier).map(Supplier::get).orElse(null);
    }

    private static Optional<MDCHelper> getHelper(Object usingObject) {
        Optional<MDCHelper> helper = Optional.ofNullable(instances.remove(usingObject));
        if (!helper.isPresent() && usingObject instanceof Throwable) {
            Throwable cause = ((Throwable)usingObject).getCause();
            return MDCHelper.getHelper(cause);
        }
        return helper;
    }

    public static <V, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable> V tryWithMDC(Supplier<? extends AbstractMDC> mdcSupplier, CheckedCallable4<V, E1, E2, E3, E4> callable) throws E1, E2, E3, E4 {
        V v;
        block7: {
            AbstractMDC mdc = mdcSupplier.get();
            try {
                v = callable.call();
                if (mdc == null) break block7;
                mdc.close();
            }
            catch (Throwable exception) {
                try {
                    MDCHelper.supplyMDC(MDCHelper.makeCurrentContextSupplier(), exception, false);
                    throw exception;
                }
                catch (Throwable throwable) {
                    if (mdc != null) {
                        try {
                            mdc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        }
        return v;
    }

    public static <V, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable> V tryWithMDC(Object usingObject, CheckedCallable4<V, E1, E2, E3, E4> callable) throws E1, E2, E3, E4 {
        V v;
        block7: {
            AbstractMDC mdc = MDCHelper.getMDC(usingObject);
            try {
                v = callable.call();
                if (mdc == null) break block7;
                mdc.close();
            }
            catch (Throwable exception) {
                try {
                    MDCHelper.supplyMDC(MDCHelper.makeCurrentContextSupplier(), exception, false);
                    throw exception;
                }
                catch (Throwable throwable) {
                    if (mdc != null) {
                        try {
                            mdc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        }
        return v;
    }

    public static <E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable> void tryWithMDC(Supplier<? extends AbstractMDC> mdcSupplier, CheckedRunnable4<E1, E2, E3, E4> runnable) throws E1, E2, E3, E4 {
        CheckedCallable4 callable = () -> {
            runnable.run();
            return null;
        };
        MDCHelper.tryWithMDC(mdcSupplier, callable);
    }

    public static <E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable> void tryWithMDC(Object usingObject, CheckedRunnable4<E1, E2, E3, E4> runnable) throws E1, E2, E3, E4 {
        CheckedCallable4 callable = () -> {
            runnable.run();
            return null;
        };
        MDCHelper.tryWithMDC(usingObject, callable);
    }

    @FunctionalInterface
    public static interface CheckedCallable4<V, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable> {
        public V call() throws E1, E2, E3, E4;
    }

    @FunctionalInterface
    public static interface CheckedRunnable4<E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable> {
        public void run() throws E1, E2, E3, E4;
    }

    @FunctionalInterface
    public static interface CheckedCallable<V, E extends Throwable>
    extends CheckedCallable2<V, E, E> {
    }

    @FunctionalInterface
    public static interface CheckedCallable2<V, E1 extends Throwable, E2 extends Throwable>
    extends CheckedCallable3<V, E1, E2, E1> {
    }

    @FunctionalInterface
    public static interface CheckedCallable3<V, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable>
    extends CheckedCallable4<V, E1, E2, E3, E1> {
    }

    @FunctionalInterface
    public static interface CheckedRunnable<E extends Throwable>
    extends CheckedRunnable2<E, E> {
    }

    @FunctionalInterface
    public static interface CheckedRunnable2<E1 extends Throwable, E2 extends Throwable>
    extends CheckedRunnable3<E1, E2, E1> {
    }

    @FunctionalInterface
    public static interface CheckedRunnable3<E1 extends Throwable, E2 extends Throwable, E3 extends Throwable>
    extends CheckedRunnable4<E1, E2, E3, E1> {
    }
}

