/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.mdc;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.bonitasoft.engine.mdc.AbstractMDC;
import org.bonitasoft.engine.mdc.MDCHelper;

public class MDCTransmitingThreadPoolExecutor
extends ThreadPoolExecutor {
    public MDCTransmitingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    public void execute(Runnable command) {
        Supplier<? extends AbstractMDC> mdcSupplier = MDCHelper.makeCurrentContextSupplier();
        super.execute(() -> MDCHelper.tryWithMDC(mdcSupplier, command::run));
    }
}

