/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.mdc;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bonitasoft.engine.mdc.AbstractMDC;
import org.bonitasoft.engine.mdc.MDCConstants;

public class ProcessInstanceMDC
extends AbstractMDC
implements AutoCloseable,
MDCConstants {
    public ProcessInstanceMDC(long processInstanceId, Optional<Long> executerId, Optional<Long> substituteUserId, long processDefinitionId, long rootProcessInstanceId) {
        super(ProcessInstanceMDC.buildContextMap(executerId, substituteUserId, processDefinitionId, processInstanceId, rootProcessInstanceId));
    }

    private static Map<String, String> buildContextMap(Optional<Long> executerId, Optional<Long> substituteUserId, long processDefinitionId, long processInstanceId, long rootProcessInstanceId) {
        if (!substituteUserId.equals(executerId)) {
            return Map.of("userId", Objects.requireNonNull(executerId.map(String::valueOf).orElse(null)), "substituteUserId", Objects.requireNonNull(substituteUserId.map(String::valueOf).orElse(null)), "processDefinitionId", String.valueOf(processDefinitionId), "processInstanceId", String.valueOf(processInstanceId), "rootProcessInstanceId", String.valueOf(rootProcessInstanceId));
        }
        if (executerId.isPresent()) {
            return Map.of("userId", executerId.map(String::valueOf).orElse(null), "processDefinitionId", String.valueOf(processDefinitionId), "processInstanceId", String.valueOf(processInstanceId), "rootProcessInstanceId", String.valueOf(rootProcessInstanceId));
        }
        return Map.of("processDefinitionId", String.valueOf(processDefinitionId), "processInstanceId", String.valueOf(processInstanceId), "rootProcessInstanceId", String.valueOf(rootProcessInstanceId));
    }
}

