/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.text.WordUtils;
import org.bonitasoft.engine.service.InjectedService;
import org.bonitasoft.engine.service.ServicesLookup;

public class ServicesResolver {
    private final ServicesLookup servicesLookup;

    public ServicesResolver(ServicesLookup servicesLookup) {
        this.servicesLookup = servicesLookup;
    }

    public void injectServices(Object target) throws InvocationTargetException, IllegalAccessException {
        Method[] methods;
        for (Method method : methods = target.getClass().getMethods()) {
            if (method.getAnnotation(InjectedService.class) == null) continue;
            String serviceName = WordUtils.uncapitalize((String)method.getName().substring(3));
            Object lookup = this.servicesLookup.lookupService(serviceName);
            method.invoke(target, lookup);
        }
    }
}

